#ifndef TILEDTO_H
#define TILEDTO_H

#include <QObject>

class TileDto : public QObject
{
	Q_OBJECT

	Q_PROPERTY(QByteArray data READ data CONSTANT)
	Q_PROPERTY(QString url READ url CONSTANT)

	public:
		TileDto(const QByteArray &data, const QString &url);

		QByteArray data() const;
		QString url() const;

	private:
		QByteArray m_data;
		QString m_url;
};

#endif // TILEDTO_H
