#ifndef TILE_H
#define TILE_H

#include <QObject>

class Player;

class Tile : public QObject
{
	Q_OBJECT

	// Det här kanske man vill ha typ som en template sen istället?
	Q_PROPERTY(int entrance READ entrance WRITE setEntrance NOTIFY entranceChanged)
	Q_PROPERTY(int candidate READ candidate WRITE setCandidate NOTIFY candidateChanged)
	Q_PROPERTY(int count READ count WRITE setCount NOTIFY countChanged)
	Q_PROPERTY(int highlight READ highlight WRITE setHighlight NOTIFY highlightChanged)

	Q_PROPERTY(Player *owner READ owner WRITE setOwner NOTIFY ownerChanged)

	Q_ENUMS(Entrance)

	public:
		enum Entrance
		{
			All = -1,
			None = 0,
			Top = 1,
			Right = 2,
			Bottom = 4,
			Left = 8
		};

		Tile(int x, int y);

		int entrance(bool strict) const;
		int entrance() const;
		void setEntrance(int entrance);

		int candidate() const;
		void setCandidate(int candidate);

		int count() const;
		void setCount(int count);

		int highlight() const;
		void setHighlight(int highlight);

		Player *owner() const;
		void setOwner(Player *owner);

		bool isCandidate(const Tile *active, int candidate, bool strict);

		int x() const;
		int y() const;

	private:
		int m_x;
		int m_y;
		int m_entrance;
		int m_candidate;
		int m_count;
		int m_highlight;

		Player *m_owner;

	signals:
		void entranceChanged();
		void candidateChanged();
		void countChanged();
		void highlightChanged();
		void ownerChanged();
};

struct Entrance
{
	static int rotate(int value)
	{
		int result = 0;

		if (value & Tile::Left)
		{
			result |= Tile::Top;
		}

		if (value & Tile::Top)
		{
			result |= Tile::Right;
		}

		if (value & Tile::Right)
		{
			result |= Tile::Bottom;
		}

		if (value & Tile::Bottom)
		{
			result |= Tile::Left;
		}

		return result;
	}
};

#endif // TILE_H
