#include <QDebug>

#include "Tile.h"
#include "Player.h"
#include "Game.h"

Tile::Tile(int x, int y)
	: m_x(x)
	, m_y(y)
	, m_entrance(Tile::None)
	, m_candidate(Tile::None)
	, m_count(0)
	, m_highlight(false)
	, m_owner(nullptr)
{

}

int Tile::entrance(bool strict) const
{
	if (!strict && m_candidate > 0)
	{
		return m_candidate;
	}

	return m_entrance;
}

int Tile::entrance() const
{
	return qMax(m_entrance, m_candidate);
}

void Tile::setEntrance(int entrance)
{
	m_entrance = entrance;

	emit entranceChanged();
	emit candidateChanged();
}

int Tile::candidate() const
{
	return m_candidate;
}

void Tile::setCandidate(int candidate)
{
	m_candidate = candidate;
	m_highlight = 0;

	emit candidateChanged();
	emit entranceChanged();
	emit highlightChanged();
}

int Tile::count() const
{
	return m_count;
}

void Tile::setCount(int count)
{
	m_count = count;

	emit countChanged();
}

int Tile::highlight() const
{
	return m_highlight;
}

void Tile::setHighlight(int highlight)
{
	m_highlight = highlight;

	emit highlightChanged();
}

Player *Tile::owner() const
{
	return m_owner ?: Player::none();
}

void Tile::setOwner(Player *player)
{
	m_owner = player;

	emit ownerChanged();
}

bool Tile::isCandidate(const Tile *active, int candidate, bool strict)
{
	if (candidate != None)
	{
		if (active)
		{
			if (entrance(strict) == None)
			{
				return (active->m_x == (m_x + 1) && active->m_y == m_y && active->entrance(strict) & Left && candidate & Right)
					|| (active->m_x == (m_x - 1) && active->m_y == m_y && active->entrance(strict) & Right && candidate & Left)
					|| (active->m_y == (m_y + 1) && active->m_x == m_x && active->entrance(strict) & Top && candidate & Bottom)
					|| (active->m_y == (m_y - 1) && active->m_x == m_x && active->entrance(strict) & Bottom && candidate & Top);
			}
		}
		else
		{
			if (!m_owner)
			{
				return !m_x || !m_y || (SIZE - m_x) == 1 || (SIZE - m_y) == 1;
			}
		}
	}

	return false;
}

int Tile::x() const
{
	return m_x;
}

int Tile::y() const
{
	return m_y;
}
