#ifndef SERVER_H
#define SERVER_H

#include <qhttpserver.h>
#include <qhttprequest.h>
#include <qhttpresponse.h>

class PlayerHandler;
class Game;

struct Action
{
	enum
	{
		Connect,
		Select
	};
};

struct Part
{
	enum
	{
		None,
		Action = 1,
		Id = 2,
		Index = 2
	};
};

class Server : public QHttpServer
{
	Q_OBJECT

	public:
		Server(PlayerHandler &playerHandler, Game &game);

	private:
		void onNewRequest(QHttpRequest *request, QHttpResponse *response);

		PlayerHandler &m_playerHandler;
		Game &m_game;
};

#endif // SERVER_H
