#include <QHostInfo>

#include "Server.h"
#include "PlayerHandler.h"
#include "Player.h"
#include "QStringEx.h"
#include "Game.h"

Server::Server(PlayerHandler &playerHandler, Game &game)
	: m_playerHandler(playerHandler)
	, m_game(game)
{
	connect(this, &QHttpServer::newRequest, this, &Server::onNewRequest);

	listen(8080);
}

void Server::onNewRequest(QHttpRequest *request, QHttpResponse *response)
{
	const QUrl &url = request->url();
	const QString &path = url
		.path()
		.toLower();

	const QStringList &parts = path.split('/');
	const QStringList actions = { "connect", "select" };

	const QString &address = request->remoteAddress();
	const QString &action = parts[Part::Action];

//	const QHostInfo &hostInfo = QHostInfo::fromName(address);
//	const QString &hostName = hostInfo.hostName();

	const int index = actions.indexOf(action);

	switch (index)
	{
		case Action::Connect:
		{
			qDebug() << "CONNECT";

			bool valid = false;

			const int id = parts
				.value(Part::Id)
				.toInt(&valid);

			if (valid)
			{
				Player *player = m_playerHandler.playerById(id);

				if (player)
				{
					player->setConnected(true);
					player->setName(address);
					player->setResponse(response);
				}
			}

			break;
		}

		case Action::Select:
		{
			qDebug() << "SELECT";

			bool valid = false;

			const int index = parts
				.value(Part::Index)
				.toInt(&valid);

			if (valid)
			{
				Player *player = m_playerHandler.playerByName(address);

				if (player)
				{
					const Reservation &reservation = player->reserve(index);

					player->setResponse(response);

					m_game.select(player, reservation);
				}
			}

			break;
		}

		default:
		{
			qDebug() << "Invalid action" << action;

			break;
		}
	}
}

