import QtQuick 2.0

ListView
{
	spacing: 32
	interactive: false

	moveDisplaced: Transition
	{
		SequentialAnimation
		{
			PauseAnimation { duration: 200 }
			NumberAnimation { properties: "y"; duration: 200 }
		}
	}

	move: Transition
	{
		SequentialAnimation
		{
			NumberAnimation { properties: "x"; to: 10; duration: 100 }
			PauseAnimation { duration: 200 }
			NumberAnimation { properties: "y"; duration: 200 }
			PauseAnimation { duration: 200 }
			NumberAnimation { properties: "x"; to: 0; duration: 100 }
		}
	}

	model: game.scoreHandler

	delegate: Row
	{
		height: 64
		spacing: 32

		Rectangle
		{
			width: 64
			height: 64
			color: modelData.player.color

			MouseArea
			{
				anchors
				{
					fill: parent
				}

				onPressAndHold: modelData.player.kill()
			}
		}

		Text
		{
			font
			{
				pixelSize: 32
				bold: true
			}

			color: modelData.player.dead ? "red" : "white"
			text: modelData.score

			anchors
			{
				verticalCenter: parent.verticalCenter
			}
		}
	}
}
