#ifndef SCOREHANDLER_H
#define SCOREHANDLER_H

#include <QObject>
#include <QList>
#include <QAbstractListModel>

class TileHandler;
class Player;
class ScoreEntry;

class ScoreHandler : public QAbstractListModel
{
	Q_OBJECT

	Q_PROPERTY(int highestScore READ highestScore NOTIFY highestScoreChanged)

	public:
		ScoreHandler(TileHandler &tileHandler, QList<Player *> &players);

		int highestScore() const;

		void invalidate(Player *player);

	private:
		TileHandler &m_tileHandler;

		QList<Player *> &m_players;
		QList<ScoreEntry *> m_scores;
		QHash<Player *, ScoreEntry *> m_entries;
		QModelIndex m_parent;

	signals:
		void highestScoreChanged();

		// QAbstractItemModel interface
	public:
		QHash<int, QByteArray> roleNames() const override;

		int rowCount(const QModelIndex &parent) const override;

		QVariant data(const QModelIndex &index, int role) const override;
};

#endif // SCOREHANDLER_H
