﻿#include "ScoreHandler.h"
#include "PlayerHandler.h"
#include "TileHandler.h"
#include "Tile.h"
#include "ScoreEntry.h"
#include "Player.h"

ScoreHandler::ScoreHandler(TileHandler &tileHandler, QList<Player *> &players)
	: m_tileHandler(tileHandler)
	, m_players(players)
{

}

int ScoreHandler::highestScore() const
{
	ScoreEntry *entry = m_scores.value(0);

	if (entry)
	{
		return entry->score();
	}

	return 0;
}

void ScoreHandler::invalidate(Player *player)
{
	for (Player *p : m_players)
	{
		if (p->connected())
		{
			if (!m_entries.contains(p))
			{
				m_entries[p] = new ScoreEntry(p);
			}
			else
			{
				m_entries[p]->resetScore();
			}
		}
	}

	ScoreEntry *entry = nullptr;

	const QList<Tile *> &tiles = m_tileHandler.tiles();

	for (Tile *tile : tiles)
	{
		Player *owner = tile->owner();
		ScoreEntry *e = m_entries.value(owner);

		if (e)
		{
			e->addScore();

			if (owner == player)
			{
				entry = e;
			}
		}
	}

	QList<ScoreEntry *> entries = m_entries.values();

	qStableSort(entries.begin(), entries.end(), &ScoreEntry::compare);

	const int oldIndex = m_scores.indexOf(entry);
	const int newIndex = entries.indexOf(entry);

	if (oldIndex > -1 &&
		oldIndex != newIndex)
	{
		beginMoveRows(m_parent, oldIndex, oldIndex, m_parent, newIndex);

		m_scores = entries;

		endMoveRows();
	}
	else
	{
		m_scores = entries;

		emit layoutChanged();
	}

	emit highestScoreChanged();
}

QHash<int, QByteArray> ScoreHandler::roleNames() const
{
	return
	{
		{ Qt::DisplayRole, "modelData" }
	};
}

int ScoreHandler::rowCount(const QModelIndex &parent) const
{
	Q_UNUSED(parent);

	return m_entries.count();
}

QVariant ScoreHandler::data(const QModelIndex &index, int role) const
{
	if (role == Qt::DisplayRole)
	{
		const int row = index.row();

		QObject *object = m_scores[row];
		QVariant value = QVariant::fromValue(object);

		return value;
	}

	return QVariant();
}
