#ifndef SCOREENTRY_H
#define SCOREENTRY_H

#include <QObject>

class Player;

class ScoreEntry : public QObject
{
	Q_OBJECT

	Q_PROPERTY(Player *player READ player CONSTANT)
	Q_PROPERTY(int score READ score NOTIFY scoreChanged)

	public:
		ScoreEntry(Player *player);

		Player *player();

		int score() const;

		void resetScore();
		void addScore();

		static bool compare(ScoreEntry *e1, ScoreEntry *e2);

	private:
		Player *m_player;

		int m_score;

	signals:
		void scoreChanged();
};

#endif // SCOREENTRY_H
