#include "ScoreEntry.h"

ScoreEntry::ScoreEntry(Player *player)
	: m_player(player)
	, m_score(0)
{

}

Player *ScoreEntry::player()
{
	return m_player;
}

int ScoreEntry::score() const
{
	return m_score;
}

void ScoreEntry::resetScore()
{
	m_score = 0;

	emit scoreChanged();
}

void ScoreEntry::addScore()
{
	m_score++;

	emit scoreChanged();
}

bool ScoreEntry::compare(ScoreEntry *e1, ScoreEntry *e2)
{
	return e1->m_score > e2->m_score;
}
