#include "QStringEx.h"

StringToken::StringToken(const QString &value)
{
	m_value = value;
}

StringToken::StringToken(const int value)
{
	m_value = QString::number(value);
}

StringToken::StringToken(const float value)
{
	m_value = QString::number(value, 'f', 3);
}

StringToken::StringToken(const double value)
{
	m_value = QString::number(value, 'f', 3);
}

StringToken::StringToken(const QByteArray &value)
{
	m_value = QString::fromUtf8(value);
}

StringToken::StringToken(const QDateTime &dateTime)
{
	m_value = dateTime.toString(Qt::ISODate);
}

StringToken::StringToken(const QHostAddress &hostAddress)
{
	m_value = hostAddress.toString();
}

StringToken::operator QString() const
{
	return m_value;
}
