#ifndef QRCODEITEM_H
#define QRCODEITEM_H

#include <QQuickPaintedItem>

class QRCodeItem : public QQuickPaintedItem
{
	Q_OBJECT

	Q_PROPERTY(QByteArray data READ data WRITE setData NOTIFY dataChanged)

	public:
		QRCodeItem();
		~QRCodeItem();

		QByteArray data() const;
		void setData(const QByteArray &data);

	private:
		void paint(QPainter *painter) override;

		QByteArray m_data;

	signals:
		void dataChanged();
};

#endif // QRCODEITEM_H
