#include <QPainter>
#include <QtMath>

#include <qrencode.h>

#include "QRCodeItem.h"

QRCodeItem::QRCodeItem()
{

}

QRCodeItem::~QRCodeItem()
{

}

void QRCodeItem::paint(QPainter *painter)
{
	QRcode *qr = QRcode_encodeString(m_data, 1, QR_ECLEVEL_M, QR_MODE_8, 0);

	if(qr)
	{
		painter->setPen(Qt::NoPen);
		painter->setBrush(Qt::black);

		const int scale = width() / qr->width;

		for(int x = 0; x < qr->width; x++)
		{
			for (int y = 0; y < qr->width; y++)
			{
				const unsigned char byte = qr->data[x + (y * qr->width)];

				if (byte & 0x01)
				{
					painter->drawRect(x * scale, y * scale, scale, scale);
				}
			}
		}
	}
	else
	{
		qDebug() << "error";
	}

	QRcode_free(qr);
}

QByteArray QRCodeItem::data() const
{
	return m_data;
}

void QRCodeItem::setData(const QByteArray &data)
{
	m_data = data;

	emit dataChanged();
}

