import QtQuick 2.0
import QtQuick.Controls 1.2
import QtQuick.Controls.Styles 1.3
import AvoidPointer 1.2

Rectangle
{
	color: "#EE000000"

	property variant selected : null

	Text
	{
		anchors
		{
			horizontalCenter: parent.horizontalCenter
			top: parent.top
			topMargin: 200
		}

		font
		{
			family: "Oxygen"
			bold: true
			pixelSize: 50
		}

		id: kask
		text: UrlHelper.getUrl("connect", selected)
		color: "white"
		visible: selected !== null
	}

	Flow
	{
		anchors
		{
			centerIn: parent
			verticalCenterOffset: -80
		}

		spacing: 50

		Repeater
		{
			model: game.playerHandler.players

			Column
			{
				spacing: 20

				Text
				{
					anchors
					{
						horizontalCenter: parent.horizontalCenter
					}

					font
					{
						pixelSize: 50
						family: "Oxygen"
						bold: true
					}

					text: "P" + (index + 1)
					color: "white"
				}

				Rectangle
				{
					width: 210
					height: 210
					color: "white"
					radius: 2

					Rectangle
					{
						anchors
						{
							fill: parent
							margins: 5
						}

						color: modelData.color
						id: rectangle
						radius: 2

						states:
						[
							State
							{
								when: !modelData.connected

								PropertyChanges
								{
									target: rectangle
									opacity: 0
								}
							},
							State
							{
								when: modelData.connected

								PropertyChanges
								{
									target: rectangle
									opacity: 1
								}
							}
						]

						Behavior on opacity
						{
							PropertyAnimation
							{
								duration: 500
							}
						}
					}

					QRCodeItem
					{
						anchors
						{
							fill: parent
							margins: 5
						}

						data: UrlHelper.getUrl("connect", modelData)
						id: code

						states:
						[
							State
							{
								when: !modelData.connected

								PropertyChanges
								{
									target: code
									opacity: 1
								}
							},
							State
							{
								when: modelData.connected

								PropertyChanges
								{
									target: code
									opacity: 0
								}
							}
						]

						Behavior on opacity
						{
							PropertyAnimation
							{
								duration: 200
							}
						}
					}

					MouseArea
					{
						anchors
						{
							fill: parent
						}

						onPressed: selected = modelData
						onReleased: selected = null
					}
				}
			}
		}
	}

	Button
	{
		anchors
		{
			horizontalCenter: parent.horizontalCenter
			bottom: parent.bottom
			bottomMargin: 200
		}

		width: 200
		height: 70
		text: "START"

		onClicked: game.begin()

		style: ButtonStyle
		{
			label: Text
			{
				font
				{
					pixelSize: 30
					family: "Oxygen"
					bold: true
				}

				text: control.text
				horizontalAlignment: Qt.AlignHCenter
				verticalAlignment: Qt.AlignVCenter
				color: "#006E29"
				style: Text.Raised
				styleColor: "#EEFFD6"
				id: text

				states:
				[
					State
					{
						when: !control.pressed

						PropertyChanges
						{
							target: text
							y: 0
						}
					},
					State
					{
						when: control.pressed

						PropertyChanges
						{
							target: text
							y: 1
						}
					}

				]
			}

			background: Rectangle
			{
				Gradient
				{
					id: normal

					GradientStop { position: 0; color: "#B1D28F" }
					GradientStop { position: 0.02; color: "#B1D28F" }
					GradientStop { position: 0.03; color: "#77B753" }
					GradientStop { position: 1; color: "#77B753" }
				}

				Gradient
				{
					id: pressed

					GradientStop { position: 0; color: "#B1D28F" }
					GradientStop { position: 0.02; color: "#4B7334" }
					GradientStop { position: 0.03; color: "#669C47" }
					GradientStop { position: 1; color: "#669C47" }
				}

				radius: 2
				id: background

				states:
				[
					State
					{
						when: !control.pressed

						PropertyChanges
						{
							target: background
							gradient: normal
							y: 0
						}
					},
					State
					{
						when: control.pressed

						PropertyChanges
						{
							target: background
							gradient: pressed
							y: 1
						}
					}

				]
			}
		}
	}
}

