#ifndef PLAYERHANDLER_H
#define PLAYERHANDLER_H

#include "PathFinder.h"

#include <QList>
#include <QObject>
#include <QQmlListProperty>
#include <QHostAddress>

class Player;

class PlayerHandler : public QObject
{
	Q_OBJECT

	Q_PROPERTY(QQmlListProperty<Player> players READ players NOTIFY playersChanged)

	public:
		PlayerHandler(QList<Player *> &players, PathFinder &pathFinder, TileHandler &tileHandler);

		QQmlListProperty<Player> players();

		Player *playerById(int id) const;
		Player *playerByName(const QString &name) const;

	private:
		QList<Player *> &m_players;

	signals:
		void playersChanged();
};

#endif // PLAYERHANDLER_H
