#include <QDebug>
#include <QDateTime>

#include "PlayerHandler.h"
#include "Player.h"

PlayerHandler::PlayerHandler(QList<Player *> &players, PathFinder &pathFinder, TileHandler &tileHandler)
	: m_players(players)
{
	QList<int> ids; // = { 0, 1, 2, 3, 4, 5 };

	const auto &dateTime = QDateTime::currentDateTime();
	const auto seed = dateTime.toTime_t();

	for (int i = 0; i < 6; i++)
	{
		qsrand(seed + i);

		ids << qrand() % 1000;
	}

	m_players =
	{
		new Player(ids[0], "#E3D7F4", &pathFinder, &tileHandler),
		new Player(ids[1], "#CDDE87", &pathFinder, &tileHandler),
		new Player(ids[2], "#FFD5D5", &pathFinder, &tileHandler),
		new Player(ids[3], "#FFE680", &pathFinder, &tileHandler),
		new Player(ids[4], "#AFDDE9", &pathFinder, &tileHandler),
		new Player(ids[5], "#E9C6AF", &pathFinder, &tileHandler)
	};
}

QQmlListProperty<Player> PlayerHandler::players()
{
	return QQmlListProperty<Player>(this, m_players);
}

Player *PlayerHandler::playerById(int id) const
{
	for (Player *player : m_players)
	{
		if (player->id() == id)
		{
			return player;
		}
	}

	return nullptr;
}

Player *PlayerHandler::playerByName(const QString &name) const
{
	for (Player *player : m_players)
	{
		if (player->name() == name)
		{
			return player;
		}
	}

	return nullptr;
}
