#ifndef PLAYER_H
#define PLAYER_H

#include <QObject>
#include <QColor>
#include <QHostAddress>

#include <qhttpresponse.h>

#include "Reservation.h"

class Tile;
class TileStack;
class PathFinder;
class TileHandler;

const int HAND_COUNT = 6;

class Player : public QObject
{
	Q_OBJECT

	Q_PROPERTY(int id READ id CONSTANT)

	Q_PROPERTY(QColor color READ color NOTIFY colorChanged)
	Q_PROPERTY(QString name READ name NOTIFY nameChanged)

	Q_PROPERTY(bool connected READ connected NOTIFY connectedChanged)
	Q_PROPERTY(bool dead READ dead NOTIFY deadChanged)

	Q_PROPERTY(Tile *tile READ tile NOTIFY tileChanged)

	public:
		Player(int id, const QColor &color, PathFinder *pathFinder, TileHandler *tileHandler);

		int id() const;

		QColor color() const;
		QList<int> &hand();

		Tile *tile() const;
		void setTile(Tile *tile);

		QString name() const;
		void setName(const QString &name);

		bool connected() const;
		void setConnected(bool connected);

		bool dead() const;
		void setDead(bool dead);

		QHttpResponse *response();
		void setResponse(QHttpResponse *response);

		void populateHand(TileStack &tileStack);
		void move(Tile *target);
		void select(int entrances);

		Reservation reserve(int index);

		static Player *none();

		operator int() const;

	public slots:
		void kill();

	private:
		void process(Tile *target);

		bool m_connected;
		bool m_dead;

		int m_id;
		int m_reserved;

		Tile *m_tile;
		PathFinder *m_pathFinder;
		TileHandler *m_tileHandler;

		QList<int> m_hand;
		QHttpResponse *m_response;

		QColor m_color;
		QString m_name;

	signals:
		void colorChanged();
		void handChanged();
		void nameChanged();
		void selectedChanged();
		void connectedChanged();
		void deadChanged();
		void tileChanged();
};

#endif // PLAYER_H
