#ifndef PATHFINDINGSTRATEGY_H
#define PATHFINDINGSTRATEGY_H

class PathFinder;
class Tile;

class PathFindingStrategy
{
	public:
		PathFindingStrategy(int dx, int dy);

		int dx() const;
		int dy() const;

		bool canEnter(const Tile *current, const Tile *candidate) const;

		static PathFindingStrategy &left();
		static PathFindingStrategy &right();
		static PathFindingStrategy &top();
		static PathFindingStrategy &bottom();

	private:
		int m_dx;
		int m_dy;
};


#endif // PATHFINDINGSTRATEGY_H
