#include "PathFindingStrategy.h"
#include "Tile.h"

PathFindingStrategy::PathFindingStrategy(int dx, int dy)
	: m_dx(dx)
	, m_dy(dy)
{

}

int PathFindingStrategy::dx() const
{
	return m_dx;
}

int PathFindingStrategy::dy() const
{
	return m_dy;
}

bool PathFindingStrategy::canEnter(const Tile *current, const Tile *candidate) const
{
	if (!candidate)
	{
		return false;
	}

	return (m_dx < 0 && current->entrance() & Tile::Left && candidate->entrance() & Tile::Right)
		|| (m_dx > 0 && current->entrance() & Tile::Right && candidate->entrance() & Tile::Left)
		|| (m_dy < 0 && current->entrance() & Tile::Top && candidate->entrance() & Tile::Bottom)
		|| (m_dy > 0 && current->entrance() & Tile::Bottom && candidate->entrance() & Tile::Top);
}

PathFindingStrategy &PathFindingStrategy::left()
{
	static PathFindingStrategy strategy(-1, 0);

	return strategy;
}

PathFindingStrategy &PathFindingStrategy::right()
{
	static PathFindingStrategy strategy(1, 0);

	return strategy;
}

PathFindingStrategy &PathFindingStrategy::top()
{
	static PathFindingStrategy strategy(0, -1);

	return strategy;
}

PathFindingStrategy &PathFindingStrategy::bottom()
{
	static PathFindingStrategy strategy(0, 1);

	return strategy;
}
