#ifndef PATHFINDER_H
#define PATHFINDER_H

#include <QList>
#include <QPair>

#include "TileCollection.h"

class Tile;
class Player;
class TileHandler;
class StepCounter;

using Krister = QPair<Tile *, int>;

struct PathFinderResult
{
	int score;

	QList<Krister> scores;
};

class PathFinder
{
	public:
		PathFinder(TileHandler &tileHandler);

		bool walkThePath(Tile *target, Player *player, StepCounter &stepCounter, TileCollection &tileCollection);

	private:
		bool walkThePath(int dx, int dy, bool probe, bool strict, Tile *current, StepCounter &stepCounter, TileCollection &tileCollection);
		bool walkToCandidate(Tile *current, TileCollection &tileCollection, bool strict);

		TileHandler &m_tileHandler;
		TileCollection m_garbage;
};

#endif // PATHFINDER_H
