#include <QtMath>

#include "PathFinder.h"
#include "PathFindingStrategy.h"
#include "Player.h"
#include "Tile.h"
#include "TileHandler.h"
#include "StepCounter.h"
#include "TileCollection.h"
#include "Path.h"

PathFinder::PathFinder(TileHandler &tileHandler)
	: m_tileHandler(tileHandler)
{

}

bool PathFinder::walkThePath(Tile *target, Player *player, StepCounter &stepCounter, TileCollection &tileCollection)
{
	Tile *playerTile = player->tile();

	if (playerTile)
	{
		const int dx = target->x() - playerTile->x();
		const int dy = target->y() - playerTile->y();

		return walkThePath(dx, dy, false, false, target, stepCounter, tileCollection);
	}
	else
	{
		tileCollection << target;

		return walkThePath(0, 0, false, true, target, stepCounter, m_garbage);
	}
}

bool PathFinder::walkThePath(int dx, int dy, bool probe, bool strict, Tile *current, StepCounter &stepCounter, TileCollection &tileCollection)
{
	if (!probe)
	{
		tileCollection << current;
	}

	const bool isValid = probe || stepCounter
		.step(current) <= 1;

	if (!isValid)
	{
		return false;
	}

	const bool hasCandidates = !m_tileHandler
		.findCandidates(current, Tile::All, strict)
		.isEmpty();

	if (!hasCandidates)
	{
		// Kan vi gå frammåt?

		const int x = current->x();
		const int y = current->y();

		Tile *target = m_tileHandler.tileAt(x + dx, y + dy);

		if (target)
		{
			// Finns en tile där

			if ((dx > 0 && current->entrance() & Tile::Right && target->entrance() & Tile::Left) ||
				(dx < 0 && current->entrance() & Tile::Left && target->entrance() & Tile::Right) ||
				(dy > 0 && current->entrance() & Tile::Bottom && target->entrance() & Tile::Top) ||
				(dy < 0 && current->entrance() & Tile::Top && target->entrance() & Tile::Bottom))
			{
				// Vi kan gå dit

				const int ndx = target->x() - x;
				const int ndy = target->y() - y;

				return walkThePath(ndx, ndy, false, strict, target, stepCounter, tileCollection);
			}
		}

		// Kan inte gå rakt fram, försök svänga

		if (!probe)
		{
			if (dx != 0)
			{
				// Horizontal

				return walkThePath(0, -dx, true, strict, current, stepCounter, tileCollection)
					|| walkThePath(0, dx, true, strict, current, stepCounter, tileCollection)
					|| walkToCandidate(current, tileCollection, strict);

			}
			else
			{
				// Vertical

				return walkThePath(dy, 0, true, strict, current, stepCounter, tileCollection)
					|| walkThePath(-dy, 0, true, strict, current, stepCounter, tileCollection)
					|| walkToCandidate(current, tileCollection, strict);
			}
		}

		return false;
	}

	return true;
}

bool PathFinder::walkToCandidate(Tile *current, TileCollection &tileCollection, bool strict)
{
	Path shortest;

	const QList<Tile *> allTiles = m_tileHandler.tiles();

	for (Tile *target : allTiles)
	{
		const bool hasCandidates = !m_tileHandler
			.findCandidates(target, Tile::All, strict)
			.isEmpty();

		if (hasCandidates)
		{
			const Path path(target, current, &m_tileHandler);

			if (shortest > path)
			{
				shortest = path;
			}
		}
	}

	return tileCollection.mergePath(shortest);
}
