#ifndef PATH_H
#define PATH_H

#include <QPair>
#include <QList>

#include "PathFindingStrategy.h"

class Tile;
class TileHandler;

using PathEntry = QPair<Tile *, int>;

class Path
{
	public:
		Path();
		Path(Tile *target, Tile *source, TileHandler *tileHandler);

		QList<Tile *> untangle() const;

		bool operator <(const Path &other) const;
		bool operator >(const Path &other) const;

	private:
		void populate(const PathEntry &entry);
		void untangle(Tile *source, QList<Tile *> &output) const;

		bool contains(Tile *tile, int score) const;

		Tile *m_source;
		TileHandler *m_tileHandler;

		QList<PathEntry> m_entries;
		QList<PathFindingStrategy> m_strategies;

		int m_score;
};

#endif // PATH_H
