#include <QFile>
#include <QDebug>
#include <QImage>
#include <QPainter>
#include <QBuffer>

#include <qhttpresponse.h>

#include "OutputHandler.h"
#include "Player.h"
#include "Tile.h"
#include "TileDto.h"
#include "TileItem.h"
#include "UrlHelper.h"

void OutputHandler::refresh(Player *player) const
{
	QHttpResponse *response = player->response();

	if (response)
	{
		QVariantList dtos;
		QFile file("template.html");

		if (file.open(QIODevice::ReadOnly))
		{
			int index = 0;

			const QList<int> &hand = player->hand();

			for (int entrance : hand)
			{
				const QColor &color = player->color();

				TileItem item;
				item.setEntrance(entrance);
				item.setColor(color);

				QImage image(TILE_SIZE * SCALE, TILE_SIZE * SCALE, QImage::Format_ARGB32);
				image.fill(0);

				QPainter painter(&image);

				item.paint(&painter);

				QByteArray imageData;
				QBuffer buffer(&imageData);

				buffer.open(QIODevice::WriteOnly);

				image.save(&buffer, "PNG");

				const QByteArray &base64 = imageData.toBase64();
				const QString &url = m_urlHelper.getUrl("select", index++);

				TileDto *dto = new TileDto(base64, url);

				dtos << QVariant::fromValue(dto);
			}

			const QByteArray &array = file.readAll();
			const QString &content = QString::fromUtf8(array);
			const QVariantHash mapping =
			{
				{ "tiles", dtos }
			};

			Grantlee::Template t = m_engine.newTemplate(content, "template");
			Grantlee::Context context(mapping);

			const QString &output = t->render(&context);
			const QByteArray &data = output.toUtf8();

			response->writeHead(QHttpResponse::STATUS_OK);
			response->end(data);
		}
		else
		{
			qDebug() << "Unable to open file template.html for reading";

			response->writeHead(QHttpResponse::STATUS_INTERNAL_SERVER_ERROR);
			response->end();
		}

		for (const QVariant &variant : dtos)
		{
			delete variant.value<QObject *>();
		}

		player->setResponse(nullptr);
	}
	else
	{
		qDebug() << "No response object!";
	}
}

