import QtQuick 2.0

Rectangle
{
	color: "#EE000000"
	id: control

	Text
	{
		anchors
		{
			top: parent.top
			horizontalCenter: parent.horizontalCenter
			topMargin: 200
		}

		font
		{
			pixelSize: 50
			family: "Oxygen"
			bold: true
		}

		color: "white"
		text: "Game over"
	}

	Row
	{
		anchors
		{
			centerIn: parent
		}

		spacing: 20
		height: 200
		id: row

		Repeater
		{
			model: game.scoreHandler

			Rectangle
			{
				anchors
				{
					bottom: row.bottom
				}

				width: 50
				height: control.opacity < 1 ? 0 : (modelData.score / game.scoreHandler.highestScore) * 200
				color: modelData.player.color

				Behavior on height
				{
					PropertyAnimation
					{
						duration: 1000
						easing
						{
							type: Easing.InQuart
						}
					}
				}
			}
		}
	}
}
