#ifndef GAME_H
#define GAME_H

#include <QObject>

#include "TileStack.h"
#include "PlayerHandler.h"
#include "Server.h"
#include "OutputHandler.h"
#include "TileHandler.h"
#include "ActionVisualizer.h"
#include "ScoreHandler.h"

class Tile;
class Player;
class Reservation;

const int TIMER = 15000;

class Game : public QObject
{
	Q_OBJECT

	Q_PROPERTY(PlayerHandler *playerHandler READ playerHandler CONSTANT)
	Q_PROPERTY(TileHandler *tileHandler READ tileHandler CONSTANT)
	Q_PROPERTY(ActionVisualizer *actionVisualizer READ actionVisualizer CONSTANT)
	Q_PROPERTY(ScoreHandler *scoreHandler READ scoreHandler CONSTANT)

	Q_PROPERTY(Player *player MEMBER m_player NOTIFY playerChanged)

	Q_PROPERTY(bool started READ started NOTIFY startedChanged)
	Q_PROPERTY(bool gameOver READ gameOver NOTIFY gameOverChanged)

	Q_PROPERTY(int timer READ timer NOTIFY timerChanged)

	public:
		Game();

		PlayerHandler *playerHandler();
		TileHandler *tileHandler();
		ActionVisualizer *actionVisualizer();
		ScoreHandler *scoreHandler();

		bool started() const;
		bool gameOver() const;

		int timer() const;

	public slots:
		void place(Tile *tile);
		void select(Player *player, const Reservation &reservation);
		void begin();
		void skipTurn();

	private:
		void timerEvent(QTimerEvent *) override;

		bool isGameOver() const;

		bool m_started;

		int m_entrance;
		int m_timer;

		QList<Player *> m_players;
		QList<Tile *> m_tiles;

		Player *m_player;

		TileHandler m_tileHandler;
		PathFinder m_pathFinder;
		PlayerHandler m_playerHandler;
		ScoreHandler m_scoreHandler;
		ActionVisualizer m_actionVisualizer;
		TileStack m_tileStack;
		Server m_server;
		OutputHandler m_outputHandler;

	signals:
		void playerChanged();
		void startedChanged();
		void gameOverChanged();
		void timerChanged();
};

#endif // GAME_H
