#ifndef BOARDVIEWMODEL_H
#define BOARDVIEWMODEL_H

#include <QObject>
#include <QQmlListProperty>

class TileHandler;
class Tile;

class BoardViewModel : public QObject
{
	Q_OBJECT

	Q_PROPERTY(TileHandler *tileHandler READ tileHandler WRITE setTileHandler NOTIFY tileHandlerChanged)

	Q_PROPERTY(QList<QObject *> tiles READ tiles NOTIFY tilesChanged)

	public:
		BoardViewModel();

		TileHandler *tileHandler() const;
		void setTileHandler(TileHandler *tileHandler);

		QList<QObject *> tiles();

	private:
		TileHandler *m_tileHandler;

	signals:
		void tilesChanged();
		void tileHandlerChanged();
};

#endif // BOARDVIEWMODEL_H
