#include "BoardViewModel.h"
#include "TileHandler.h"
#include "Tile.h"

BoardViewModel::BoardViewModel()
	: m_tileHandler(nullptr)
{

}

TileHandler *BoardViewModel::tileHandler() const
{
	return m_tileHandler;
}

void BoardViewModel::setTileHandler(TileHandler *tileHandler)
{
	m_tileHandler = tileHandler;

	emit tileHandlerChanged();
	emit tilesChanged();
}

QList<QObject *> BoardViewModel::tiles()
{
	QList<QObject *> result;

	if (m_tileHandler)
	{
		const QList<Tile *> &tiles = m_tileHandler->tiles();

		for (Tile *tile : tiles)
		{
			result << tile;
		}
	}

	return result;
}

