import QtQuick 2.0
import AvoidPointer 1.2

Rectangle
{
	color: "#374548"

	BoardViewModel
	{
		id: board
		tileHandler: game.tileHandler
	}

	ScoreTable
	{
		anchors
		{
			top: parent.top
			left: parent.left
			bottom: parent.bottom
			right: grid.left
			margins: 64
		}
	}

	Rectangle
	{
		anchors
		{
			centerIn: parent
		}

		border
		{
			color: "white"
		}

		width: 989
		height: 989
		color: "transparent"

		ScoreTable
		{
			anchors
			{
				top: parent.top
				bottom: parent.bottom
				left: grid.left
				right: parent.right
				margins: 64
			}

			rotation: 180
		}

		Rectangle
		{
			anchors
			{
				horizontalCenter: parent.horizontalCenter
				bottom: grid.top
				margins: 1
			}

			width: (game.timer / 15000) * 960
			height: 10
		}

		Rectangle
		{
			anchors
			{
				horizontalCenter: parent.horizontalCenter
				top: grid.bottom
				margins: 1
			}

			width: (game.timer / 15000) * 960
			height: 10
		}

		Rectangle
		{
			anchors
			{
				verticalCenter: parent.verticalCenter
				right: grid.left
				margins: 1
			}

			width: 10
			height: (game.timer / 15000) * 960
		}

		Rectangle
		{
			anchors
			{
				verticalCenter: parent.verticalCenter
				left: grid.right
				margins: 1
			}

			width: 10
			height: (game.timer / 15000) * 960
		}

		Flow
		{
			anchors
			{
				centerIn: parent
				margins: 64
			}

			width: 960
			height: 960
			id: grid

			Repeater
			{
				model: board.tiles

				TileItem
				{
					id: tile

					color: modelData.owner.color
					entrance: modelData.entrance
					active: modelData.owner.tile === modelData

					Rectangle
					{
						anchors
						{
							fill: parent
						}

						color: "white"
						visible: modelData.candidate > 0
						opacity: 0.5
					}

					Rectangle
					{
						anchors
						{
							fill: parent
						}

						color: "red"
						opacity: modelData.highlight / 4
					}

					MouseArea
					{
						anchors
						{
							fill: parent
						}

						onClicked: game.place(modelData)
					}
				}
			}
		}

		Image
		{
			anchors
			{
				centerIn: parent
			}

			id: actionIndicator
			source: game.actionVisualizer.fileName
			opacity: 0

			Connections
			{
				target: game.actionVisualizer

				onFileNameChanged: animation.start()
			}

			ParallelAnimation
			{
				id: animation

				SequentialAnimation
				{
					NumberAnimation
					{
						target: actionIndicator
						property: "opacity"
						to: 1
					}

					NumberAnimation
					{
						target: actionIndicator
						property: "opacity"
						to: 0
					}
				}

				NumberAnimation
				{
					target: actionIndicator
					property: "scale"
					from: 0.7
					to: 1
				}
			}
		}
	}
}

