#ifndef ACTIONVISUALIZER_H
#define ACTIONVISUALIZER_H

#include <QObject>
#include <QString>

class ActionVisualizer : public QObject
{
	Q_OBJECT

	Q_PROPERTY(QString fileName READ fileName NOTIFY fileNameChanged)

	public:
		enum Action
		{
			Select,
			Rotate
		};

		ActionVisualizer();

		QString fileName() const;

		void visualize(int action);

	private:
		int m_action;

	signals:
		void fileNameChanged();
};

#endif // ACTIONVISUALIZER_H
