var stroboShader = function(){
  var uniforms = {
    "time":   { type: "f", value: 0.0 }
  };
  
  var vertexShader = [
    "varying vec2 vUv;",
    "void main(){",
      "vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"
  ].join("\n");
  
  var fragmentShader = [
    "uniform float time;",
    "varying vec2 vUv;",
    "void main(){",
      "vec3 col = vec3(.5, 1., .7)*(.5+sin(time*.001)*.3);",
      "float dist = distance( vUv, vec2( 0.5 ) )+cos(time*.12);",
      "col *= smoothstep( 0.9, .05 * 0.799, dist *( 0.9 + .05 ) );",
      "gl_FragColor = vec4(col,1.0);",
    "}"
  ].join("\n");
  
  return {
    uniforms : uniforms,
    vertexShader : vertexShader,
    fragmentShader : fragmentShader
  }
}