var Kaari = function(){
  PartBase.call(this);
  this.initScene();
}

Kaari.prototype = PartBase.prototype.inheritance();

Kaari.prototype.initScene = function(){
  //Ei käytä default inittiä, koska erilainen kamera!
  
  this.scene = new THREE.Scene();
  this.shader = kaariShader();
  this.shader.uniforms.resolution.value = new THREE.Vector2(TDEMO.width, TDEMO.height);
  
  //otetaan käyttöön toinen kamera
	this.camera = new THREE.OrthographicCamera(TDEMO.minx, TDEMO.maxx, TDEMO.maxy, TDEMO.miny);
	this.camera.position.z = 1;
	this.scene.add(this.camera);
  
  this.material = new THREE.ShaderMaterial({
    uniforms: this.shader.uniforms,
    vertexShader: this.shader.vertexShader,
    fragmentShader: this.shader.fragmentShader
  });
  
  var matka = Math.PI*3.5;
  var aika = MUSIC.syncPoints.verse2Start-MUSIC.syncPoints.chorusStart;
  this.velocity = matka/aika;
  
  this.display = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height),
    this.material);
	this.display.position.z = -1;
  this.scene.add(this.display);
  
}

Kaari.prototype.animate = function(timeStep, elapsedTime){
  PartBase.prototype.animate.call(this, timeStep, elapsedTime);
  this.shader.uniforms.time.value = (elapsedTime-this.startTime)*this.velocity;
  if(elapsedTime >= MUSIC.syncPoints.chorusMiddle){
    this.shader.uniforms.phase.value = 1.0;
  }
}
