﻿//-----------------------------------------------------
// Nimiavaruus
//-----------------------------------------------------
TDEMO = {
  audioStatus : false,
  inited : false,
  user : false,
  started : false,
  
  //ajastus ja parttien vaihto
  timeElapsed : 0,
  timeHelper : 0, // In case of no audio
  
  animationSpeed : 1/60,//animation speed
  maxSkip : 3,
  nextTick : 0,
  
  brightnessDark : -3.0,
  brightnessDefault: 0.0,
  brightnessBright : 1.0,

  displayCredits : MUSIC.syncPoints.lastBeat-MUSIC.spb,
  fadeCredits : MUSIC.duration,
  creditsVisible : false,
  creditsFaded : false,
  end : MUSIC.duration,
  
  width : 0,
  height : 0,
  minx : 0,
  maxx : 0,
  miny : 0,
  maxy : 0,
  
  //some camera parameters
  fov: 55,
  near : 0.2,
  far: 800,
  aspect : 1,
  
  mainloop : function(){
    
    if(!TDEMO.started){
      TDEMO.started = true;
      TDEMO.mainPart.prepare(0);

      if(TDEMO.audio !== undefined) {
        TDEMO.audio.play();
      }
      
      TDEMO.timeHelper = Date.now()/1000;
    }
    
    if(TDEMO.audio !== undefined) {
      TDEMO.timeElapsed = TDEMO.audio.currentTime;
    }
    else {
      TDEMO.timeElapsed = TDEMO.timeElapsed + (Date.now()/1000 - TDEMO.timeHelper);
      TDEMO.timeHelper = Date.now()/1000;
    }    
    
    //looping through transitions
    for(var a = 0; a < TDEMO.transitions.length; ++a){
      var transition = TDEMO.transitions[a];
      //middle of transformation
      if(!transition.done && TDEMO.timeElapsed >= transition.startTime && TDEMO.timeElapsed < transition.endTime){
        var t = TDEMO.timeElapsed - transition.startTime;
        var s = transition.velocity * t;
        transition.uniform.value = transition.startValue + s;
      }
      else if(!transition.done && TDEMO.timeElapsed >= transition.endTime){
        transition.uniform.value = transition.endValue;
        transition.done = true;
      }
    }
    
    //looping through part changes
    for(var b = 0; b < TDEMO.partChanges.length; ++b){
      var change = TDEMO.partChanges[b];
      if(!change.done && TDEMO.timeElapsed >= change.time){
        change.to.prepare(TDEMO.timeElapsed);
        change.done = true;
        TDEMO.mainPart = change.to;
        if(change.next){
          TDEMO.nextPart = change.next;
        }
      }
    }
    
    //The animation loop
    var loops = 0;
    while( TDEMO.timeElapsed > TDEMO.nextTick && loops < TDEMO.maxSkip) {      
      TDEMO.mainPart.animate(TDEMO.animationSpeed, TDEMO.timeElapsed);
      TDEMO.nextTick += TDEMO.animationSpeed;
      loops++;
    }
    
    var interpolation = (TDEMO.timeElapsed + TDEMO.animationSpeed - TDEMO.nextTick )/TDEMO.animationSpeed;
    TDEMO.mainPart.render(TDEMO.elapsedTime, interpolation, TDEMO.mainRTT);
    
    var delta = TDEMO.clock.getDelta();
    TDEMO.composer.render(delta);
    TDEMO.finalComposer.render(delta);
    
    //Credits are shown at timepoint displayCredits
    if(TDEMO.timeElapsed >= TDEMO.displayCredits){
      var credits = document.getElementById("credits");
      if(!TDEMO.creditsVisible){
        credits.style.display = "block";
        credits.style.opacity = 0.8;
        TDEMO.creditsVisible = true;
      }//Credits are faded away
      if(!TDEMO.creditsFaded && TDEMO.timeElapsed >= TDEMO.fadeCredits){
        credits.style.opacity = parseFloat(credits.style.opacity)-0.1;
        if(parseFloat(credits.style.opacity) <= 0.0){
          TDEMO.creditsFaded = true;
        }
      }
    }
    
    if(TDEMO.audio.ended && TDEMO.creditsFaded){
      cancelAnimationFrame(TDEMO.mainloop);
      //tässä voi piilottaa canvaksen, jos haluaa
    }
    else{
      requestAnimationFrame(TDEMO.mainloop);
    }
  }
  
};

//-----------------------------------------------------
// FUNKTIOT JOTKA ALOITTAA KAIKEN
//-----------------------------------------------------
//aloitetaan demo, kun kaikki alustustoimenpiteet
//on varmasti suoritettu
var allLoaded = function(){
  if(document.getElementById("audio") == null) {
    TDEMO.audioStatus = true;
  }
  if(TDEMO.audioStatus && TDEMO.inited && TDEMO.user){
    document.getElementById("loader").style.display = "none";
    TDEMO.mainloop();
  }
};

var audioReady = function(){
  TDEMO.audioStatus = true;
  TDEMO.audio = document.getElementById("audio");
  
  allLoaded();
};


var onResize = function(){
  var demoEl = document.getElementById("demo");
  demoEl.style.position = "absolute";
  demoEl.style.top = ((window.innerHeight-TDEMO.height)/2).toString() + "px";
  demoEl.style.left = ((window.innerWidth-TDEMO.width)/2).toString() + "px";
}

var start = function(){
  
  window.addEventListener("resize", onResize);
  
  document.getElementById("start").style.display = "none";
  document.getElementById("demo").style.display = "block";
  document.getElementById("demo").style.cursor="none";
  document.getElementById("loader").style.display = "block";
  init();

  setTimeout(function(){
    TDEMO.user = true;
    allLoaded();
  }, 5000);
};
//-----------------------------------------------------

//-----------------------------------------------------
// Parttien luominen ja alustaminen.
//-----------------------------------------------------
var initParts= function(){
  
  TDEMO.parts = [
    new Strobo(),//gradientti
    new Cubes(),//kuutiotunneli
    new Kaari(),//kaari
    new Shadercubes(),//kuutio + shader juttu
    new Texts() //greetsit
  ];
  
  //Two first parts are inited to these variables
  TDEMO.mainPart = TDEMO.parts[0];
  TDEMO.nextPart = TDEMO.parts[1];
  
 // TDEMO.nextPart.switchAnimation(Tunneli.prototype.animate2);//Tämä on ihan vaan testi

  var getVelocity = function(startValue, endValue, startTime, endTime){
    var t = endTime-startTime;
    var s = endValue-startValue;
    var v = s/t;
    return v;
  }
  
  //partti muutokset
  TDEMO.partChanges = [
    {//Transition 1
      to : TDEMO.parts[1],//kuutiotunneli
      next : TDEMO.parts[2],//kaari
      time : MUSIC.syncPoints.verse1Start,
      done : false
    },
    {//Transition 2
      to : TDEMO.parts[2],//kaari
      next: TDEMO.parts[3],//kuutio + shader
      time : MUSIC.syncPoints.chorusStart,
      done : false
    },
    {//Transition 3
      to : TDEMO.parts[3],//kuutio + shader
      next: TDEMO.parts[4],//greetit
      time : MUSIC.syncPoints.verse2Start,
      done : false
    },
    {//Transition 4
      to : TDEMO.parts[4],//greetit
      next: false,
      time : MUSIC.syncPoints.modulation,
      done : false
    }
  ];
  
  //Brightness and contrast changes & blurring
  TDEMO.transitions = [
   {//Fade in after intro
      startTime : 0,
      endTime : MUSIC.barLength*2,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDark,
      endValue : TDEMO.brightnessDefault,
      done : false
    },
    //------------------------------------------------
    {//bright at the end of gradient
      startTime : MUSIC.syncPoints.verse1Start-MUSIC.spb,
      endTime : MUSIC.syncPoints.verse1Start,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessBright,
    },
    {//back to normal
      startTime : MUSIC.syncPoints.verse1Start,
      endTime : MUSIC.syncPoints.verse1Start+2*MUSIC.spb,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessBright,
      endValue : TDEMO.brightnessDefault,
    },
    //------------------------------------------------
    {//blink 1
      startTime : MUSIC.syncPoints.fill-MUSIC.spb*0.25,
      endTime : MUSIC.syncPoints.fill,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessBright,
    },
    {//back to normal
      startTime : MUSIC.syncPoints.fill,
      endTime : MUSIC.syncPoints.fill+MUSIC.spb*0.25,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessBright,
      endValue : TDEMO.brightnessDefault,
    },
    //------------------------------------------------
   {//blink2
      startTime : MUSIC.syncPoints.fill+MUSIC.spb*0.75,
      endTime : MUSIC.syncPoints.fill+MUSIC.spb,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessBright,
    },
    {//back to normal
      startTime : MUSIC.syncPoints.fill+MUSIC.spb,
      endTime : MUSIC.syncPoints.fill+MUSIC.spb*1.25,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessBright,
      endValue : TDEMO.brightnessDefault,
    },
    //------------------------------------------------
    {//blink3
      startTime : MUSIC.syncPoints.fill+MUSIC.spb*1.75,
      endTime : MUSIC.syncPoints.fill+MUSIC.spb*2,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessBright,
    },
    {//back to normal
      startTime : MUSIC.syncPoints.fill+MUSIC.spb*2,
      endTime : MUSIC.syncPoints.fill+MUSIC.spb*2.25,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessBright,
      endValue : TDEMO.brightnessDefault,
    },
    //------------------------------------------------
    {//bright at the end of tunnel
      startTime : MUSIC.syncPoints.fill+MUSIC.spb*2.75,
      endTime : MUSIC.syncPoints.fill+MUSIC.spb*3,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessBright,
    },
    {//back to normal
      startTime : MUSIC.syncPoints.fill+MUSIC.spb*3,
      endTime : MUSIC.syncPoints.fill+MUSIC.spb*3.25,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessBright,
      endValue : TDEMO.brightnessDefault,
    },
    //------------------------------------------------
    {//start of colors
      startTime : MUSIC.syncPoints.chorusMiddle-MUSIC.spb*0.25,
      endTime : MUSIC.syncPoints.chorusMiddle,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessBright,
    },
    {//back to normal
      startTime : MUSIC.syncPoints.chorusMiddle,
      endTime : MUSIC.syncPoints.chorusMiddle+MUSIC.spb*0.25,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessBright,
      endValue : TDEMO.brightnessDefault,
    },
    //------------------------------------------------
    {//end of kaari
      startTime : MUSIC.syncPoints.verse2Start-2*MUSIC.spb,
      endTime : MUSIC.syncPoints.verse2Start-MUSIC.spb,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessBright,
    },
    {//back to normal
      startTime : MUSIC.syncPoints.verse2Start,
      endTime : MUSIC.syncPoints.verse2Start+2*MUSIC.spb,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessBright,
      endValue : TDEMO.brightnessDefault,
    },
    //------------------------------------------------
    {//end of kuutio + shaderi
      startTime : MUSIC.syncPoints.modulation-MUSIC.spb,
      endTime : MUSIC.syncPoints.modulation,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessDark,
    },
    {//back to normal
      startTime : MUSIC.syncPoints.modulation,
      endTime : MUSIC.syncPoints.modulation+MUSIC.spb,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDark,
      endValue : TDEMO.brightnessDefault,
    },
    //------------------------------------------------
    {//bright out
      startTime : MUSIC.syncPoints.lastBeat-MUSIC.spb*2,
      endTime : MUSIC.syncPoints.lastBeat,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessDefault,
      endValue : TDEMO.brightnessBright,
      done : false
    },
    {//Fade out
      startTime : MUSIC.syncPoints.lastBeat,
      endTime : MUSIC.syncPoints.end,
      uniform : TDEMO.brightness.uniforms[ "brightness" ],
      startValue : TDEMO.brightnessBright,
      endValue : TDEMO.brightnessDark,
      done : false
    }
  ];

  //Calculating velocity of transition
  for(var i = 0; i < TDEMO.transitions.length; ++i){
    var t = TDEMO.transitions[i];
    t.velocity = getVelocity(t.startValue, t.endValue, t.startTime, t.endTime);  
  }
};

//-----------------------------------------------------
// Alustaa renderöintiin liittyvät jutut
//-----------------------------------------------------
var init = function(){

  TDEMO.clock = new THREE.Clock();
  TDEMO.aspect = TDEMO.width/TDEMO.height;
  
  //some commonly used values
  TDEMO.minx = -TDEMO.width/2;
  TDEMO.maxx = TDEMO.width/2;
  TDEMO.miny = -TDEMO.height/2;
  TDEMO.maxy = TDEMO.height/2;
  
  //alustetaan renderer
  TDEMO.renderer = new THREE.WebGLRenderer();
  TDEMO.renderer.setSize(TDEMO.width, TDEMO.height);
  TDEMO.renderer.setClearColor(0x000000);
  TDEMO.renderer.autoClear = true;
  TDEMO.renderer.preserveDrawingBuffer = false;
  
  TDEMO.renderer.shadowMapEnabled = true;

  
  TDEMO.renderer.domElement.style.width = TDEMO.width;
  TDEMO.renderer.domElement.style.height = TDEMO.height;
  document.getElementById("demo").appendChild(TDEMO.renderer.domElement);
  
  TDEMO.mainRTT = new THREE.WebGLRenderTarget(TDEMO.width, TDEMO.height, {
    minFilter: THREE.LinearFilter,
    magFilter: THREE.NearestFilter,
    format: THREE.RGBFormat
  });
  
  TDEMO.scene = new THREE.Scene();
	TDEMO.camera = new THREE.OrthographicCamera(TDEMO.minx, TDEMO.maxx, TDEMO.maxy, TDEMO.miny);
	TDEMO.camera.position.z = 1;
	TDEMO.scene.add(TDEMO.camera);
  
  TDEMO.displayMaterial = new THREE.MeshBasicMaterial({map : TDEMO.mainRTT});
  
  TDEMO.display = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height),
    TDEMO.displayMaterial);
	TDEMO.display.position.z = -1;
  TDEMO.scene.add(TDEMO.display);
  
  //POSTPROCESSING PIPELINE
  //COMPOSER
  TDEMO.composer = new THREE.EffectComposer(TDEMO.renderer);
  TDEMO.renderPass = new THREE.RenderPass(TDEMO.scene, TDEMO.camera);
  

  //THE VISUAL PIPELINE WHICH IS APPLIED TO ALL BY DEFAULT
  
  TDEMO.bloom = new THREE.BloomPass(5);
  //THE LAST THING TO COMBINE ALL
  TDEMO.copyPass = new THREE.ShaderPass(THREE.CopyShader);
  TDEMO.copyPass.renderToScreen = true;
  
  TDEMO.composer.addPass(TDEMO.renderPass);
  TDEMO.composer.addPass(TDEMO.bloom);
  TDEMO.composer.addPass(TDEMO.copyPass);
  
  TDEMO.finalComposer = new THREE.EffectComposer(TDEMO.renderer);
  TDEMO.finalRenderPass = new THREE.RenderPass(TDEMO.scene, TDEMO.camera);
  
  TDEMO.blend = new THREE.ShaderPass(THREE.ParaguayAdd);
  TDEMO.blend.needsSwap = true;
  TDEMO.blend.uniforms.tDiffuse2.value = TDEMO.composer.renderTarget2;
  
  TDEMO.brightness = new THREE.ShaderPass(THREE.ParaguayColorCorrect);
  
  TDEMO.finalCopy = new THREE.ShaderPass(THREE.CopyShader);
  TDEMO.finalCopy.renderToScreen = true;
  
  TDEMO.finalComposer.addPass(TDEMO.finalRenderPass);
  TDEMO.finalComposer.addPass(TDEMO.blend);
  TDEMO.finalComposer.addPass(TDEMO.brightness);
  TDEMO.finalComposer.addPass(TDEMO.finalCopy);
  
  initParts();
  
  //alustus on tehty, kutsutaan tarkastusfunktiota
  TDEMO.inited = true;
  allLoaded();
};






