function text_cursor() {

    this.text ;
    this.vbl ;
    this.canvas ;
    this.font ;
    this.speed ;
    this.cursorspeed ;
    this.currentchar ;
    this.endchar ;
    this.line ;
    this.char ;
    this.cursoron ;

    this.init = function(mytext,speed,cursorspeed,font) {
        this.font = font ;
        this.text = mytext.split("@") ;
        this.endchar = 0 ;

        var maxwidth = 0 ;
        for (var i=0; i<this.text.length; i++) {
            this.endchar += this.text[i].length ;
            if (this.text[i].length > maxwidth) maxwidth = this.text[i].length ;
        }
        this.canvas = new canvas(this.font.tilew * maxwidth,this.font.tileh * this.text.length) ;
        this.canvas.clear() ;

        this.char = 0 ;
        this.line = 0 ;
        this.currentchar = 0 ;
        this.cursoron = 1 ;

        this.speed = speed ;
        this.cursorspeed = cursorspeed ;

        this.vbl = 0 ;
    }

    this.drawcursor = function(dest,x,y,px,py) {
        if (this.vbl % this.cursorspeed == 0) { this.cursoron = - this.cursoron ; }
        if (this.cursoron == 1) dest.quad(x + px*this.font.tilew,y + py*this.font.tileh, this.font.tilew, this.font.tileh,"#ffffff") ;
    }

    this.render = function(dest,x,y) {        
        this.vbl ++ ;
        if (this.vbl % this.speed == 0) {
            if (this.currentchar != this.endchar) {
                this.currentchar ++ ;
                if (this.char < this.text[this.line].length) {
                    this.char ++ ;
                } else {
                    this.line ++ ;
                    this.char = 1 ;
                    if (this.line >= this.text.length) this.currentchar = this.endchar ;
                }
                if (this.text[this.line] != "") {
                    font_keyb.print(this.canvas,this.text[this.line][this.char-1],font_keyb.tilew*(this.char-1)+2,font_keyb.tileh*this.line+2) ;
                    this.font.print(this.canvas,this.text[this.line][this.char-1],this.font.tilew*(this.char-1),this.font.tileh*this.line) ;
                }
                else this.char -- ;
            }
        }
        this.drawcursor(dest,x,y,this.char,this.line) ;
        this.canvas.draw(dest,x,y) ;
    }
}