package main;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import javax.swing.JOptionPane;

public class LastProdukter {
	private String path;

	public LastProdukter(String path) {
		this.path = path;
		try {
			lesData();
		} catch (FileNotFoundException e) {
			JOptionPane.showMessageDialog(null, "Fil: " + path + "ikke funnet!\nLag en ny database fil ved  trykke p \"Lagre Database\" p hoved vinduet.", "Error!", 0);
		}
	}

	private void lesData() throws FileNotFoundException {
		FileReader fReader = new FileReader(path);

		BufferedReader bReader = new BufferedReader(fReader);

		String line;

		try {
			while ((line = bReader.readLine()) != null) {
				String[] lineSplit = line.split(";");

				if (lineSplit[0].equals("produkt")) {

					try {
						String prodNavn = lineSplit[1];
						int prodID = Integer.parseInt(lineSplit[2]);
						double salgsPris = Double.parseDouble(lineSplit[3]);
						double kjopsPris = Double.parseDouble(lineSplit[4]);

						Produkt prod = new Produkt(prodNavn, prodID, salgsPris,
								kjopsPris);
						Main.getProdList().add(prod);
					} catch (NumberFormatException e) {
						System.out.println("Error: Number Format Exception");
						System.out.println(e.toString());
					}

				}
			}
			
			bReader.close();
			fReader.close();
			
		} catch (IOException e) {
			System.out.println("Input/Output Exception!");
			System.out.println(e.toString());
		}


	}

}
