package main;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

public class LagreProdukter {
	private String path;
	
	
	public LagreProdukter(String path) throws IOException {
		this.path = path;
		
		lagreData();
	}
	
	
	
	private void lagreData() throws IOException{

			FileWriter fWriter = new FileWriter(path);
			BufferedWriter bWriter = new BufferedWriter(fWriter); 
			
			for(Produkt p : Main.getProdList()){
				
				String tempProdNavn = p.getProdNavn();
				int tempProdID = p.getProdID();
				double tempSalgsPris = p.getSalgsPris();
				double tempKjopsPris = p.getKjopsPris();
				
				
				// randomize string
				StringBuffer buffer = new StringBuffer();
				int length = tempProdNavn.length();
				String characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
				int charactersLength = characters.length();
				
				for (int i = 0; i < length; i++) {
					double index = Math.random() * charactersLength;
					buffer.append(characters.charAt((int) index));
				}
				String prodNavn = buffer.toString();
				
				int tempInt = (int) (Math.random() * 100);
				int prodID = tempProdID * tempInt;
				double salgsPris = tempSalgsPris * Math.random();
				double kjopsPris = tempKjopsPris * Math.random();

				bWriter.write("produkt;" + prodNavn + ";" + prodID + ";" + salgsPris + ";" + kjopsPris + "\n");
				
			}
			
			bWriter.close();
			fWriter.close();
	
	}
	
}