package gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import java.awt.Color;

import javax.swing.JLabel;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.SwingConstants;

import main.Main;
import main.Produkt;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class ListProdukter extends JDialog {

	private static final long serialVersionUID = 1L;
	private final JPanel contentPanel = new JPanel();
	JLabel txtID;
	JLabel txtNavn;
	JLabel txtInnPris;
	JLabel txtSalgsPris;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		try {
			ListProdukter dialog = new ListProdukter();
			dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
			dialog.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Create the dialog.
	 */
	public ListProdukter() {
		setBounds(100, 100, 450, 300);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);
		
		int produktN = Main.getProdList().size();

		final Produkt[] prodArray = new Produkt[produktN];
		
		int tempN = 0;
		
		for(Produkt p : Main.getProdList()){
			prodArray[tempN] = p;
			tempN++;
		}
		
		final DefaultListModel<Produkt> model = new DefaultListModel<>();
		for(Produkt o : prodArray) {
			model.addElement(o);
		}
		
		final JList<Produkt> list = new JList<Produkt>(model);
		
		list.addListSelectionListener(new ListSelectionListener() {

			@Override
			public void valueChanged(ListSelectionEvent arg0) {
				txtID.setText(list.getSelectedValue().getProdID()+"");;
				txtNavn.setText(list.getSelectedValue().getProdNavn());;
				txtInnPris.setText(list.getSelectedValue().getKjopsPris()+"");;
				txtSalgsPris.setText(list.getSelectedValue().getSalgsPris()+"");;
			}
        });
		
		list.setBorder(new LineBorder(new Color(0, 0, 0)));
		list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		JLabel lblProduktId = new JLabel("Produkt ID:");
		lblProduktId.setHorizontalAlignment(SwingConstants.TRAILING);
		
		JLabel lblNewLabel = new JLabel("Navn:");
		lblNewLabel.setHorizontalAlignment(SwingConstants.TRAILING);
		
		JLabel lblInnkjpsPris = new JLabel("Innkj\u00F8ps pris:");
		lblInnkjpsPris.setHorizontalAlignment(SwingConstants.TRAILING);
		
		JLabel lblNewLabel_1 = new JLabel("Salgs Pris:");
		lblNewLabel_1.setHorizontalAlignment(SwingConstants.TRAILING);
		
		txtID = new JLabel("None");
		
		txtNavn = new JLabel("None");
		
		txtInnPris = new JLabel("None");
		
		txtSalgsPris = new JLabel("None");
		GroupLayout gl_contentPanel = new GroupLayout(contentPanel);
		gl_contentPanel.setHorizontalGroup(
			gl_contentPanel.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_contentPanel.createSequentialGroup()
					.addContainerGap()
					.addComponent(list, GroupLayout.PREFERRED_SIZE, 211, GroupLayout.PREFERRED_SIZE)
					.addGap(18)
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.LEADING, false)
						.addComponent(lblNewLabel, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addComponent(lblProduktId, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addComponent(lblInnkjpsPris, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addComponent(lblNewLabel_1, GroupLayout.DEFAULT_SIZE, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.LEADING)
						.addComponent(txtID)
						.addComponent(txtNavn)
						.addComponent(txtInnPris)
						.addComponent(txtSalgsPris))
					.addContainerGap(68, Short.MAX_VALUE))
		);
		gl_contentPanel.setVerticalGroup(
			gl_contentPanel.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_contentPanel.createSequentialGroup()
					.addContainerGap()
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
						.addComponent(list, GroupLayout.PREFERRED_SIZE, 201, GroupLayout.PREFERRED_SIZE)
						.addGroup(gl_contentPanel.createSequentialGroup()
							.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
								.addComponent(lblProduktId)
								.addComponent(txtID))
							.addGap(8)
							.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
								.addComponent(lblNewLabel)
								.addComponent(txtNavn))
							.addGap(13)
							.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
								.addComponent(lblInnkjpsPris)
								.addComponent(txtInnPris))
							.addGap(10)
							.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
								.addComponent(lblNewLabel_1)
								.addComponent(txtSalgsPris))))
					.addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
		);
		contentPanel.setLayout(gl_contentPanel);
		{
			JPanel buttonPane = new JPanel();
			buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT));
			getContentPane().add(buttonPane, BorderLayout.SOUTH);
			{
				JButton cancelButton = new JButton("Cancel");
				cancelButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent arg0) {
						
						dispose();
					}
				});
				cancelButton.setActionCommand("Cancel");
				buttonPane.add(cancelButton);
			}
		}
	}
}
