/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import main.Main;
import main.Produkt;

public class LastProdukter {
    private String path;

    public LastProdukter(String path) {
        this.path = path;
        try {
            this.lesData();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "Fil: " + path + "ikke funnet!\nLag en ny database fil ved \u00e5 trykke p\u00e5 \"Lagre Database\" p\u00e5 hoved vinduet.", "Error!", 0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void lesData() throws FileNotFoundException {
        FileReader fReader = new FileReader(this.path);
        BufferedReader bReader = new BufferedReader(fReader);
        try {
            while (true) {
                String line;
                if ((line = bReader.readLine()) == null) {
                    bReader.close();
                    fReader.close();
                    return;
                }
                String[] lineSplit = line.split(";");
                if (!lineSplit[0].equals("produkt")) continue;
                try {
                    String prodNavn = lineSplit[1];
                    int prodID = Integer.parseInt(lineSplit[2]);
                    double salgsPris = Double.parseDouble(lineSplit[3]);
                    double kjopsPris = Double.parseDouble(lineSplit[4]);
                    Produkt prod = new Produkt(prodNavn, prodID, salgsPris, kjopsPris);
                    Main.getProdList().add(prod);
                }
                catch (NumberFormatException e) {
                    System.out.println("Error: Number Format Exception");
                    System.out.println(e.toString());
                }
            }
        }
        catch (IOException e) {
            System.out.println("Input/Output Exception!");
            System.out.println(e.toString());
        }
    }
}

