import pygame
from pygame import *
from settings import *

sizeMultiplier = 2

def loadSprite(name, convert = True, colorkey = Color("#000000")):
	"""
	Load a sprite and scale it to twice size
	"""

	if 'assets' in name:
		image = pygame.image.load(name + ".png")
	else:
		image = pygame.image.load("assets/sprites/" + name + ".png")

	if convert:
		image = image.convert()

	if colorkey:
		image.set_colorkey(colorkey)

	w,h = image.get_size()
	return pygame.transform.scale(image, (w*sizeMultiplier, h*sizeMultiplier))

def onScreen(rectangle):
	"""
	Checks if a rectangle is within screen coordinates.
	"""

	x,y = rectangle.topleft
	w,h = rectangle.size

	if (-w < x < sw) and (120-h < y < sh):
		return True

	return False

def playMusic(name):
	"""
	Load music and loop indefinetely
	"""

	if music:
		pygame.mixer.music.load("assets/music/" + name + ".ogg")
		pygame.mixer.music.play(-1)