#version 110
uniform sampler2D diffuse;
uniform sampler2D normals;
uniform sampler2D emitter;
uniform vec2 scale;
uniform vec2 offset;
uniform float rotation;
uniform float flip;
void main()
{
    vec2 coord = gl_TexCoord[0].xy * scale + offset;
    vec4 diffuse_color = texture2D(diffuse, coord).rgba;
    vec4 normals_color = texture2D(normals, coord).rgba;
    vec4 emitter_color = texture2D(emitter, coord).rgba;
    
    if (flip > 0.0)
        normals_color.r = 1.0 - normals_color.r;
    
    float sn = sin(rotation);
    float cs = cos(rotation);
    vec2 tmp = normals_color.xy * 2.0 - 1.0;
    vec2 dir = vec2(
        tmp.x*cs + tmp.y*sn,
        tmp.x*sn + tmp.y*cs);
    dir = (dir + 1.0) / 2.0;
    normals_color.xy = dir.xy;
    
    normals_color.a = diffuse_color.a;
    emitter_color.a = diffuse_color.a;
    gl_FragData[0] = diffuse_color;
    gl_FragData[1] = normals_color;
    gl_FragData[2] = emitter_color;
}