#version 130
uniform int tile_size;
uniform ivec2 dimensions;
uniform sampler2D texels;
uniform sampler2D diffuse;
uniform sampler2D normals;
vec4 Desaturate(vec3 color, float Desaturation)
{
	vec3 grayXfer = vec3(0.3, 0.59, 0.11);
	vec3 gray = vec3(dot(grayXfer, color));
	return vec4(mix(color, gray, Desaturation), 1.0);
}
void main()
{
    // Constants
    int colordepth = 256;                       // Each channel has 8 bits
    float cd = float(colordepth);
    //int tile_size = 8;                          // Tile size in pixels
    int tile_area = tile_size * 2;              // Full tile size in pixels
    int tileset_dim = 256;                      // Width/height of the tile texture
    int tileset_cnt = tileset_dim / tile_area;  // Number of tiles in a row/col in texture
    float tsc = float(tileset_cnt);
    
    // Create coordinates
     vec2 dm = vec2(dimensions);                                 // Tile map size
     vec2 tf = gl_TexCoord[0].xy;                                   // Texture fraction
    float ts = float(tile_size);
    ivec2 tp = ivec2(tf*dm*ts+ts/2.0);                  // Texture pixel coordinate
    ivec2 lp = tp - tile_size*(tp/tile_size);                       // Tile pixel coordinate
     vec2 lf = vec2(lp)/float(tileset_dim);                                // Tile texture fraction
     vec4 t1 = texture2D(texels, tf+vec2( 0.5, 0.5)/dm); // Upper left  tile coordinate
     vec4 t2 = texture2D(texels, tf+vec2(-0.5, 0.5)/dm); // Upper right tile coordinate
     vec4 t3 = texture2D(texels, tf+vec2( 0.5,-0.5)/dm); // Lower left  tile coordinate
     vec4 t4 = texture2D(texels, tf+vec2(-0.5,-0.5)/dm); // Lower right tile coordinate
     int c1 = int(t1.x * cd);
     int c2 = int(t2.x * cd);
     int c3 = int(t3.x * cd);
     int c4 = int(t4.x * cd);
     t1.x = float((c1 & 1)   + (c1 & 8)/4) / cd;
     t2.x = float((c2 & 1)   + (c2 & 2)  ) / cd;
     t3.x = float((c3 & 4)/4 + (c3 & 8)/4) / cd;
     t4.x = float((c4 & 2)/1 + (c4 & 4)/4) / cd;
    
    // Texture fetch
     vec4 d1 = texture2D(diffuse, (t1.xy*cd+vec2(0.0,0.0))/tsc+lf); // Upper left  tile texture
     vec4 d2 = texture2D(diffuse, (t2.xy*cd+vec2(0.5,0.0))/tsc+lf); // Upper right tile texture
     vec4 d3 = texture2D(diffuse, (t3.xy*cd+vec2(0.0,0.5))/tsc+lf); // Lower left  tile texture
     vec4 d4 = texture2D(diffuse, (t4.xy*cd+vec2(0.5,0.5))/tsc+lf); // Lower right tile texture
     vec4 n1 = texture2D(normals, (t1.xy*cd+vec2(0.0,0.0))/tsc+lf); // Upper left  tile texture
     vec4 n2 = texture2D(normals, (t2.xy*cd+vec2(0.5,0.0))/tsc+lf); // Upper right tile texture
     vec4 n3 = texture2D(normals, (t3.xy*cd+vec2(0.0,0.5))/tsc+lf); // Lower left  tile texture
     vec4 n4 = texture2D(normals, (t4.xy*cd+vec2(0.5,0.5))/tsc+lf); // Lower right tile texture
     //d1.gb -= (1-t1.a)*0.3;
     //d2.gb -= (1-t2.a)*0.3;
     //d3.gb -= (1-t3.a)*0.3;
     //d4.gb -= (1-t4.a)*0.3;
    
    // Merge textures from all quadrants
     vec4 f1 = d1;
     vec4 f2 = vec4(d2.rgb*(1.0-f1.a)+f1.rgb*f1.a, max(d2.a,f1.a));
     vec4 f3 = vec4(d3.rgb*(1.0-f2.a)+f2.rgb*f2.a, max(d3.a,f2.a));
     vec4 f4 = vec4(d4.rgb*(1.0-f3.a)+f3.rgb*f3.a, max(d4.a,f3.a));
     vec4 m1 = n1;
     vec4 m2 = vec4(n2.rgb*(1.0-m1.a)+m1.rgb*m1.a, max(n2.a,m1.a));
     vec4 m3 = vec4(n3.rgb*(1.0-m2.a)+m2.rgb*m2.a, max(n3.a,m2.a));
     vec4 m4 = vec4(n4.rgb*(1.0-m3.a)+m3.rgb*m3.a, max(n4.a,m3.a));
    
    // Ouput the result
    gl_FragData[0] = f4;
    gl_FragData[1] = m4;
    gl_FragData[2] = vec4(0,0,0,f4.a);
}
