#version 140
#extension GL_ARB_compatibility: enable
#extension GL_ARB_shading_language_420pack: enable

in vec4 color;
in vec2 tex;
in vec3 normal, lightDir, eyeVec;
layout (binding=0) uniform sampler2D colormap; 
layout (binding=2) uniform sampler2D normalmap;

void main(void) { 
	vec4 final_color = 
	(gl_FrontLightModelProduct.sceneColor * gl_FrontMaterial.ambient) + 
	(gl_LightSource[0].ambient * gl_FrontMaterial.ambient);
		
	vec3 N = normalize(normal);
	vec3 L = normalize(lightDir);

 // if (normalmap != 0) {
	// 	vec3 B = texture2D(normalmap, tex).xyz * 2.0 - 1.0;
//	  N = N * B;
//	}
	
	float lambertTerm = dot(N,L);
	
	if(lambertTerm > 0.0)
	{
		final_color += gl_LightSource[0].diffuse *
		               gl_FrontMaterial.diffuse * 
					   lambertTerm;	
		
		vec3 E = normalize(eyeVec);
		vec3 R = reflect(-L, N);
		float specular = pow( max(dot(R, E), 0.0),
		                 gl_FrontMaterial.shininess );
		final_color += gl_LightSource[0].specular * 
		               gl_FrontMaterial.specular *
					   specular;	
	}

	gl_FragColor = final_color * texture(colormap,tex);
	//gl_FragColor = vec4(1.0); //texture(colormap, tex); //color * -1.0; // 
}