﻿using System.Collections.Generic;

namespace segfault {
   class Step : Pos {
      public int Distance { get { return Parent != null ? 1 + Parent.Distance : 0; } }

      public Step Parent { get; set; }

      public Step FirstValidStep { get { return Parent == null || Parent.Direction == Dir.INVALID ? this : Parent.FirstValidStep; } }

      public IEnumerable<Step> AllSteps { get { yield return this; if (this != FirstValidStep) foreach (var s in Parent.AllSteps) yield return s; } }

      public Step(Pos p, Step parent = null) {
         X = p.X;
         Y = p.Y;
         Parent = parent;
      }

      public Dir Direction {
         get {
            return Parent == null ? Dir.INVALID :
               Parent.X < X ? Dir.Right :
               Parent.X > X ? Dir.Left :
               Parent.Y < Y ? Dir.Down : Dir.Up;
         }
      }

      public override string ToString() {
         return
            Parent == null ? "" :
            Parent.ToString() + (
            Parent.X < X ? ">" :
            Parent.X > X ? "<" :
            Parent.Y < Y ? "v" : "^");
      }
   }
}
