﻿#undef DEBUG

using System;

namespace segfault {
   public class Pos : IComparable {
      public int X, Y;

      public Pos() { }
      public Pos(Pos p) : this(p.X, p.Y) { }
      public Pos(int x, int y) { X = x; Y = y; }
      public Pos(string l) { var ll = l.Split(','); X = int.Parse(ll[0]); Y = int.Parse(ll[1]); }

      public int CompareTo(object obj) {
         var b = obj as Pos;
         if (b == null)
#if DEBUG
            throw new ArgumentException("one does not simply compare pos and " + (obj ?? new NULL()).GetType());
#else
         return 0;
#endif

         int res = X.CompareTo(b.X);
         return res != 0 ? res : Y.CompareTo(b.Y);
      }

      public Pos Offset(Dir d, int dist = 1) {
         return new Pos(X + (d == Dir.Left ? -dist : d == Dir.Right ? dist : 0), Y + (d == Dir.Up ? -dist : d == Dir.Down ? dist : 0));
      }

      public bool SamePos(Pos p) {
         return X == p.X && p.Y == Y;
      }

      public int Manhattan(Pos p) {
         return Math.Abs(X - p.X) + Math.Abs(Y - p.Y);
      }

      public override string ToString() {
         return string.Format("{0}:{1}", X, Y);
      }
   }
}
