#!/usr/bin/python           # This is server.py file

import socket               # Import socket module
import json
import re
import copy
from random import random
from random import shuffle
from collections import deque
from time import sleep

s = socket.socket()         # Create a socket object
host = socket.gethostname() # Get local machine name
port = 54321                # Reserve a port for your service.

s.connect((host, port))
s.send(b"NAME Motherfish\n")
s.send(b"JSON\n")


inputbuf = ""


def read_packet():
    global inputbuf
    
    try:
        inputbuf = s.recv(4096)
    except:
        print "Ah, lite swag"

def processData(state):
    for i in range(len(state['map'])):  # Lists are the shit
        state['map'][i] = list(state['map'][i])


    #Bombs on the map
    bMap = state['map']
    tall = ['0', '1', '2', '3', '4', '5']
    for i in range(len(state['bombs'])):
        #Place the bombs
        bMap[state['bombs'][i]['y']][state['bombs'][i]['x']] = 'B'
        #Down
        if(state['height'] - state['bombs'][i]['y']>1):
            if(not(bMap[state['bombs'][i]['y']+1][state['bombs'][i]['x']] == '#') and not(bMap[state['bombs'][i]['y']+1][state['bombs'][i]['x']] == '+')):
                if(bMap[state['bombs'][i]['y']+1][state['bombs'][i]['x']] in tall):
                    if(int(bMap[state['bombs'][i]['y']+1][state['bombs'][i]['x']]) > int(state['bombs'][i]['state'])):
                        bMap[state['bombs'][i]['y']+1][state['bombs'][i]['x']] = str(state['bombs'][i]['state'])
                elif(bMap[state['bombs'][i]['y']+1][state['bombs'][i]['x']] == 'B'):
                    state['bombs'].append({'x': state['bombs'][i]['x'], 'y': state['bombs'][i]['y']+1, 'state': state['bombs'][i]['state']})
                else:
                    bMap[state['bombs'][i]['y']+1][state['bombs'][i]['x']] = str(state['bombs'][i]['state'])
                if(state['height'] - state['bombs'][i]['y']>2):
                    if(not(bMap[state['bombs'][i]['y']+2][state['bombs'][i]['x']] == '#') and not(bMap[state['bombs'][i]['y']+2][state['bombs'][i]['x']] == '+')):
                        if(bMap[state['bombs'][i]['y']+2][state['bombs'][i]['x']] in tall):
                            if(int(bMap[state['bombs'][i]['y']+2][state['bombs'][i]['x']]) > int(state['bombs'][i]['state'])):
                                bMap[state['bombs'][i]['y']+2][state['bombs'][i]['x']] = str(state['bombs'][i]['state'])
                        elif(bMap[state['bombs'][i]['y']+2][state['bombs'][i]['x']] == 'B'):
                            state['bombs'].append({'x': state['bombs'][i]['x'], 'y': state['bombs'][i]['y']+2, 'state': state['bombs'][i]['state']})
                        else:
                            bMap[state['bombs'][i]['y']+2][state['bombs'][i]['x']] = str(state['bombs'][i]['state'])
        #Up
        if(state['bombs'][i]['y']>0):
            if(not(bMap[state['bombs'][i]['y']-1][state['bombs'][i]['x']] == '#') and not(bMap[state['bombs'][i]['y']-1][state['bombs'][i]['x']] == '+')):
                if(bMap[state['bombs'][i]['y']-1][state['bombs'][i]['x']] in tall):
                    if(int(bMap[state['bombs'][i]['y']-1][state['bombs'][i]['x']]) > int(state['bombs'][i]['state'])):
                        bMap[state['bombs'][i]['y']-1][state['bombs'][i]['x']] = str(state['bombs'][i]['state'])
                elif(bMap[state['bombs'][i]['y']-1][state['bombs'][i]['x']] == 'B'):
                    state['bombs'].append({'x': state['bombs'][i]['x'], 'y': state['bombs'][i]['y']-1, 'state': state['bombs'][i]['state']})
                else:
                    bMap[state['bombs'][i]['y']-1][state['bombs'][i]['x']] = str(state['bombs'][i]['state'])
                if(state['bombs'][i]['y']>-1):
                    if(not(bMap[state['bombs'][i]['y']-2][state['bombs'][i]['x']] == '#') and not(bMap[state['bombs'][i]['y']-2][state['bombs'][i]['x']] == '+')):
                        if(bMap[state['bombs'][i]['y']-2][state['bombs'][i]['x']] in tall):
                            if(int(bMap[state['bombs'][i]['y']-2][state['bombs'][i]['x']]) > int(state['bombs'][i]['state'])):
                                bMap[state['bombs'][i]['y']-2][state['bombs'][i]['x']] = str(state['bombs'][i]['state'])
                        elif(bMap[state['bombs'][i]['y']-2][state['bombs'][i]['x']] == 'B'):
                            state['bombs'].append({'x': state['bombs'][i]['x'], 'y': state['bombs'][i]['y']-2, 'state': state['bombs'][i]['state']})
                        else:
                            bMap[state['bombs'][i]['y']-2][state['bombs'][i]['x']] = str(state['bombs'][i]['state'])
        #Right
        if(state['width'] - state['bombs'][i]['x']>1):
            if(not(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+1] == '#') and not(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+1] == '+')):
                if(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+1] in tall):
                    if(int(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+1]) > int(state['bombs'][i]['state'])):
                        bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+1] = str(state['bombs'][i]['state'])
                elif(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+1] == 'B'):
                    state['bombs'].append({'x': state['bombs'][i]['x']+1, 'y': state['bombs'][i]['y'], 'state': state['bombs'][i]['state']})
                else:
                    bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+1] = str(state['bombs'][i]['state'])
                if(state['width'] - state['bombs'][i]['x']>2):
                    if(not(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+2] == '#') and not(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+2] == '+')):
                        if(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+2] in tall):
                            if(int(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+2]) > int(state['bombs'][i]['state'])):
                                bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+2] = str(state['bombs'][i]['state'])
                        elif(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+2] == 'B'):
                            state['bombs'].append({'x': state['bombs'][i]['x']+2, 'y': state['bombs'][i]['y'], 'state': state['bombs'][i]['state']})
                        else:
                            bMap[state['bombs'][i]['y']][state['bombs'][i]['x']+2] = str(state['bombs'][i]['state'])
        #Left
        if(state['bombs'][i]['x']>0):
            if(not(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-1] == '#') and not(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-1] == '+')):
                if(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-1] in tall):
                    if(int(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-1]) > int(state['bombs'][i]['state'])):
                        bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-1] = str(state['bombs'][i]['state'])
                elif(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-1] == 'B'):
                    state['bombs'].append({'x': state['bombs'][i]['x']-1, 'y': state['bombs'][i]['y'], 'state': state['bombs'][i]['state']})
                else:
                    bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-1] = str(state['bombs'][i]['state'])
                if(state['bombs'][i]['x']>-1):
                    if(not(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-2] == '#') and not(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-2] == '+')):
                        if(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-2] in tall):
                            if(int(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-2]) > int(state['bombs'][i]['state'])):
                                bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-2] = str(state['bombs'][i]['state'])
                        elif(bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-2] == 'B'):
                            state['bombs'].append({'x': state['bombs'][i]['x']-2, 'y': state['bombs'][i]['y'], 'state': state['bombs'][i]['state']})
                        else:
                            bMap[state['bombs'][i]['y']][state['bombs'][i]['x']-2] = str(state['bombs'][i]['state'])

        #Place the bombs again
        bMap[state['bombs'][i]['y']][state['bombs'][i]['x']] = 'B'
    state['map'] = bMap

    #Players on the map 
    for i in range(len(state['players'])):
        state['map'][state['players'][i]['y']][state['players'][i]['x']] = 'P' 

    return state

def predictState(state, ticks):
    if(ticks<=0):
        return state
    tall = ['0', '1', '2', '3', '4', '5']
    for i in range(len(state['map'])):
        for j in range(len(state['map'][i])):
            if(state['map'][i][j] in tall):
                if(state['map'][i][j] == '0'):
                    state['map'][i][j] = '.'
                else:
                    state['map'][i][j] = str(int(state['map'][i][j])-1)

    for i in range(len(state['bombs'])):
        if(int(state['bombs'][i]['state']) <= 0):
            state['map'][state['bombs'][i]['y']][state['bombs'][i]['x']] = '.'
        state['bombs'][i]['state'] = str(int(state['bombs'][i]['state'])-1)
    return predictState(state,ticks-1)

def inDanger(state):
    tall = ['0', '1', '2', '3', '4', '5']
    if(state['map'][state['y']][state['x']] in tall or state['map'][state['y']][state['x']] == 'B'):
        return True
    else:
        return False

def inSuperDanger(state):
    tall = ['0', '1']
    if((state['map'][state['y']][state['x']] in tall) or (state['map'][state['y']][state['x']] == 'B')):
        return True
    else:
        return False

def isOnMap(state, x, y):
    if(x < 0):
        return False
    if(y < 0):
        return False
    if(state['width'] - x < 0):
        return False
    if(state['height'] - y < 0):
        return False
    return True

def findBestMove(state, mi):
    x = state['x']
    y = state['y']
    tmpState = copy.deepcopy(state)
    visited = copy.deepcopy(state['map'])
    goalNode = {'x': -1, 'y': -1}

    for i in range(len(visited)):
        for j in range(len(visited[i])):
            visited[i][j] = -1
    qu = deque()
#qu.append({'x': x, 'y': y, 'tick': 1, 'move': 0})
    
    qu.append({'x': x, 'y': y+1, 'tick': 1, 'move': 1}) #Down
    qu.append({'x': x, 'y': y-1, 'tick': 1, 'move': 2}) #Up
    qu.append({'x': x+1, 'y': y, 'tick': 1, 'move': 3}) #Right
    qu.append({'x': x-1, 'y': y, 'tick': 1, 'move': 4}) #Left
    while(len(qu) > 0):
        tmp = qu.popleft()
        x = tmp['x']
        y = tmp['y']
#       print str(x) + " " + str(y)
        tick = tmp['tick']
#       print "kom til 1"
        if(not(isOnMap(state, x, y))):
            continue
#       print "kom til 2"
        if(tick > 5-mi):
            continue
#       print "kom til 3"
        if(visited[y][x] != -1):
            continue
        if(state['map'][y][x] == 'B' or state['map'][y][x] == '#' or state['map'][y][x] == '+' or state['map'][y][x] == 'P'):
            continue
#       print "kom til 4"
        
        visited[y][x] = tmp['move']
        tmpState['x'] = x
        tmpState['y'] = y
        if(inSuperDanger(predictState(tmpState, tick))):
            continue
#       print "kom til 5"
#       print state['map'][y][x]
#       print "############"
#       for i in range(len(state['map'])):
#            print state['map'][i]
        if(state['map'][y][x] == '.'):
            goalNode = {'x': x, 'y': y}
#           print "FANT ET SPOT OMG!"
            break
#       print "La til node!"
        qu.append({'x': x, 'y': y+1, 'tick': tick+1, 'move': 1}) #Down
        qu.append({'x': x, 'y': y-1, 'tick': tick+1, 'move': 2}) #Up
        qu.append({'x': x+1, 'y': y, 'tick': tick+1, 'move': 3}) #Right
        qu.append({'x': x-1, 'y': y, 'tick': tick+1, 'move': 4}) #Left

    if(goalNode['x'] == -1):
#        for i in range(len(state['map'])):
#            print state['map'][i]
#        print "########"
#        for i in range(len(visited)):
#            print visited[i]
        return -1

    prevMove = -1
    gx = goalNode['x']
    gy = goalNode['y']
#    print str(gy) + " lol " + str(gx)
#    print "Kom seg hit ogsA"
#print visited
#    printState(state)
    failsafe = 1 #Best practice, yea 
    while(visited[gy][gx] != -1 and failsafe < 10):
        prevMove = visited[gy][gx]
#print "prevMove: " + str(prevMove) + " (" + str(gx) + "," + str(gy) + ")"
        if(prevMove == 1): 
            gy = gy - 1
        elif(prevMove == 2):
            gy = gy + 1
        elif(prevMove == 3):
            gx = gx - 1
        else:
            gx = gx + 1
        failsafe = failsafe + 1
    return prevMove


def safeToPlaceBomb(state):
    tmpState = copy.deepcopy(state)
    tmpState['bombs'].append({'x': tmpState['x'], 'y': tmpState['y'], 'state': 3})
    if(findBestMove(processData(tmpState),2) != -1):
        return True
    else:
        return False

def printState(state): #Only used for debugging
    for i in range(len(state['map'])):
        print str(state['map'][i]).translate(None, 'u,[]\'')
    
    print "\n\nCoordinates"
    print ("X: %s" % state['x'])
    print ("Y: %s" % state['y'])

    print "\n\nBombs"
    for i in range(len(state['bombs'])):
        print ("(%s,%s) %s" % (state['bombs'][i]['x'],
                state['bombs'][i]['y'], state['bombs'][i]['state']))

    print "\nPlayers"
    for i in range(len(state['players'])):
        print ("(%s,%s) %s" % (state['players'][i]['x'],
                    state['players'][i]['y'], state['players'][i]['id']))


while True:
    sleep(0.1)

    read_packet()
    try:
        state = json.loads(inputbuf)
    except:
        continue
    
    dirs = [0, 1, 2, 3]
    if(state['type'] == "status update"):
        state = processData(state)
#printState(predictState(state,2))
        printState(state)
        if(inDanger(state)):
            bestMove = findBestMove(state,0)
            if(bestMove == -1):
                s.send(b"SAY Oh shi..\n")
            elif(bestMove == 1):
                s.send(b"DOWN\n")
            elif(bestMove == 2):
                s.send(b"UP\n")
            elif(bestMove == 3):
                s.send(b"RIGHT\n")
            elif(bestMove == 4):
                s.send(b"LEFT\n")
            continue
        elif(safeToPlaceBomb(state)):
            l = int(random() * 6)
            if(l>1 and len(state['bombs']) < 5):
                s.send(b"BOMB\n")
                continue
        
        shuffle(dirs)
        for i in range(len(dirs)):
            r = dirs[i]
            tmpState = copy.deepcopy(state)
            if (r == 0):
                if(not(isOnMap(tmpState,tmpState['x'],tmpState['y']-1))):
                    continue
                if(tmpState['map'][tmpState['y']-1][tmpState['x']] != '.'):
                    continue
                tmpState['y'] = tmpState['y']-1
                if(not(inDanger(tmpState))):
                    s.send(b"UP\n")
            elif (r == 1):
                if(not(isOnMap(tmpState,tmpState['x'],tmpState['y']+1))):
                    continue
                if(tmpState['map'][tmpState['y']+1][tmpState['x']] != '.'):
                    continue
                tmpState['y'] = tmpState['y']+1
                if(not(inDanger(tmpState))):
                    s.send(b"DOWN\n")
            elif (r == 2):
                if(not(isOnMap(tmpState,tmpState['x']+1,tmpState['y']))):
                    continue
                if(tmpState['map'][tmpState['y']][tmpState['x']+1] != '.'):
                    continue
                tmpState['x'] = tmpState['x']+1
                if(not(inDanger(tmpState))):
                    s.send(b"RIGHT\n")
            elif (r == 3):
                if(not(isOnMap(tmpState,tmpState['x']-1,tmpState['y']))):
                    continue
                if(tmpState['map'][tmpState['y']][tmpState['x']-1] != '.'):
                    continue
                tmpState['x'] = tmpState['x']-1
                if(not(inDanger(tmpState))):
                    s.send(b"LEFT\n")
            break
s.close                     # Close the socket when done
