/*
 * Decompiled with CFR 0.152.
 */
package kai;

import java.awt.Point;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Kai {
    public static void main(String[] args) {
        String hostName = args[0];
        int portNumber = 54321;
        try {
            Socket socket = new Socket(hostName, portNumber);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            Scanner scanner = new Scanner(socket.getInputStream());
            Pattern playerPattern = Pattern.compile("(\\d+) (\\d+),(\\d+)");
            Pattern bombPattern = Pattern.compile("(\\d+),(\\d+) (\\d+)");
            Pattern beginPattern = Pattern.compile("PLAYERS|DEAD|ENDOFROUND");
            out.println("NAME Kai");
            out.println("SAY Kai the Artificial Intelligence,");
            Kai.skipTicks(scanner, 8);
            out.println("SAY reporting for duty!");
            while (true) {
                int i;
                String line;
                String command = "";
                while (!(line = scanner.nextLine()).contains("PLAYERS")) {
                }
                HashMap<Integer, Integer[]> players = new HashMap<Integer, Integer[]>();
                line = scanner.nextLine();
                while (!line.contains("ENDPLAYERS")) {
                    Matcher m = playerPattern.matcher(line);
                    m.find();
                    int id = Integer.parseInt(m.group(1));
                    Integer[] pos = new Integer[]{Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3))};
                    players.put(id, pos);
                    line = scanner.nextLine();
                }
                HashSet<int[]> bombs = new HashSet<int[]>();
                line = scanner.nextLine();
                line = scanner.nextLine();
                while (!line.contains("ENDBOMBS")) {
                    Matcher m = bombPattern.matcher(line);
                    m.find();
                    int[] bomb = new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3))};
                    if (bomb[2] >= 0) {
                        bombs.add(bomb);
                    }
                    line = scanner.nextLine();
                }
                int x = Integer.parseInt(scanner.nextLine().substring(2));
                int y = Integer.parseInt(scanner.nextLine().substring(2));
                int height = Integer.parseInt(scanner.nextLine().substring(7));
                int width = Integer.parseInt(scanner.nextLine().substring(6));
                Tile[][] map = new Tile[height][width];
                HashMap<Character, Tile> tileTypes = new HashMap<Character, Tile>();
                tileTypes.put(Character.valueOf('+'), Tile.HARD);
                tileTypes.put(Character.valueOf('.'), Tile.NONE);
                tileTypes.put(Character.valueOf('#'), Tile.SOFT);
                line = scanner.nextLine();
                for (int i2 = 0; i2 < height; ++i2) {
                    line = scanner.nextLine();
                    for (int j = 0; j < width; ++j) {
                        map[i2][j] = (Tile)((Object)tileTypes.get(Character.valueOf(line.charAt(j))));
                    }
                }
                Integer[][] safeMap = new Integer[height][width];
                for (int i3 = 0; i3 < height; ++i3) {
                    for (int j = 0; j < width; ++j) {
                        if (map[i3][j] == Tile.NONE) continue;
                        Kai.setSafeMap(safeMap, j, i3, 0);
                    }
                }
                for (Integer[] player : players.values()) {
                    Kai.setSafeMap(safeMap, player[0], player[1], 0);
                }
                for (int[] bomb : bombs) {
                    for (i = -2; i <= 2; ++i) {
                        Kai.setSafeMap(safeMap, bomb[0] + i, bomb[1], bomb[2]);
                        Kai.setSafeMap(safeMap, bomb[0], bomb[1] + i, bomb[2]);
                    }
                    Kai.setSafeMap(safeMap, bomb[0], bomb[1], 0);
                }
                Dir move = Kai.moveDirToSafety(safeMap, new Point(x, y));
                int[][] targetMap = new int[height][width];
                if (move == Dir.IDLE) {
                    for (i = 0; i < height; ++i) {
                        for (int j = 0; j < width; ++j) {
                            if (map[i][j] == Tile.SOFT) {
                                targetMap[i][j] = 1;
                            }
                            if (map[i][j] != Tile.HARD) continue;
                            targetMap[i][j] = -1;
                        }
                    }
                    for (Integer[] player : players.values()) {
                        targetMap[player[1].intValue()][player[0].intValue()] = 2;
                    }
                    Point pos = new Point(x, y);
                    if (Kai.viableSpot(targetMap, safeMap, pos)) {
                        command = "BOMB";
                    } else {
                        move = Kai.moveDirToViableSpot(targetMap, safeMap, pos);
                        Point nextPos = new Point(pos);
                        if (move == Dir.RIGHT) {
                            ++nextPos.x;
                        } else if (move == Dir.LEFT) {
                            --nextPos.x;
                        } else if (move == Dir.DOWN) {
                            ++nextPos.y;
                        } else if (move == Dir.UP) {
                            --nextPos.y;
                        }
                        if (safeMap[nextPos.y][nextPos.x] != null) {
                            move = Kai.canMoveToSafely(safeMap, pos, nextPos);
                        }
                        if (move == Dir.IDLE) {
                            if (safeMap[y][x] == null) {
                                System.out.println("Waiting, no danger");
                            } else {
                                System.out.println("Waiting, ticks left: " + safeMap[y][x]);
                            }
                            command = safeMap[y][x] != null && safeMap[y][x] == 2 ? Kai.giveUp() : Kai.stall();
                        } else {
                            command = move.name();
                        }
                    }
                } else {
                    command = move.name();
                }
                System.out.println(command);
                out.println(command);
            }
        }
        catch (IOException ex) {
            System.exit(0);
            return;
        }
    }

    private static void skipTicks(Scanner scanner, int ticks) {
        for (int i = 0; i < ticks; ++i) {
            while (!scanner.nextLine().contains("ENDMAP")) {
            }
        }
    }

    private static String stall() {
        String[] comments = new String[]{"I eat poop.", "9/11 was an inside job.", "Wow. Much bomb. Very #.", "I'm still alive.", "Could you come over here?", "The cake is a lie.", "He was dead all along!?", "Luke, I am your father.", "Kablooie!", "Let's get funky.", "Wanna \"A\" my \"I\"?"};
        String comment = "";
        if (500.0 * Math.random() <= 1.0) {
            comment = "SAY " + comments[(int)(Math.random() * (double)comments.length)];
        }
        return comment;
    }

    private static String giveUp() {
        String[] comments = new String[]{"Well shit.", "Well fuck.", "Damn.", "Bye bye!", "AAAAAAAAHHH!", "Tell my wife I love her.", "See you in hell!"};
        return "SAY " + comments[(int)(Math.random() * (double)comments.length)];
    }

    private static void setSafeMap(Integer[][] safeMap, int x, int y, int safety) {
        if (x >= 0 && x < safeMap[0].length && y >= 0 && y < safeMap.length) {
            safeMap[y][x] = Integer.MAX_VALUE;
            if (safety < safeMap[y][x]) {
                safeMap[y][x] = safety;
            }
        }
    }

    private static boolean safestConnected(Integer[][] safeMap, HashMap<Point, Dir> moveDir, ArrayList<Point> tested, ArrayList<Point> testNext, Point testNow, Point safest, int step) {
        if (safeMap[testNow.y][testNow.x] == null) {
            safest.setLocation(testNow);
            return false;
        }
        Integer safetyHere = safeMap[testNow.y][testNow.x] - step;
        tested.add(testNow);
        if (safetyHere < 2 && step >= 0) {
            return true;
        }
        if (safetyHere > safeMap[safest.y][safest.x]) {
            safest.setLocation(testNow);
        }
        if (safetyHere < 2 && step == 0) {
            moveDir.put(testNow, Dir.IDLE);
            return true;
        }
        Point[] surrounding = new Point[]{new Point(testNow.x - 1, testNow.y), new Point(testNow.x + 1, testNow.y), new Point(testNow.x, testNow.y - 1), new Point(testNow.x, testNow.y + 1)};
        System.out.println("");
        for (Point point : surrounding) {
            if (point.x < 0 || point.x >= safeMap[0].length || point.y < 0 || point.y >= safeMap.length || tested.contains(point)) continue;
            if (!testNext.contains(point)) {
                testNext.add(point);
            }
            System.out.println(point + ": dir of " + testNow + "(" + (Object)((Object)moveDir.get(testNow)) + ")");
            if (moveDir.containsKey(point)) continue;
            moveDir.put(point, moveDir.get(testNow));
        }
        return true;
    }

    private static Dir moveDirToSafety(Integer[][] safeMap, Point pos) {
        boolean cont;
        int x = pos.x;
        int y = pos.y;
        int step = -1;
        Point safest = new Point(x, y);
        HashMap<Point, Dir> moveDir = new HashMap<Point, Dir>();
        moveDir.put(safest, Dir.IDLE);
        moveDir.put(new Point(x, y - 1), Dir.UP);
        moveDir.put(new Point(x + 1, y), Dir.RIGHT);
        moveDir.put(new Point(x, y + 1), Dir.DOWN);
        moveDir.put(new Point(x - 1, y), Dir.LEFT);
        ArrayList<Point> tested = new ArrayList<Point>();
        ArrayList<Point> testNext = new ArrayList<Point>();
        testNext.add(safest);
        boolean bl = cont = safeMap[safest.y][safest.x] != null;
        while (cont && !testNext.isEmpty()) {
            Point testNow;
            ArrayList<Point> testNowAll = testNext;
            testNext = new ArrayList();
            Iterator i$ = testNowAll.iterator();
            while (i$.hasNext() && (cont = Kai.safestConnected(safeMap, moveDir, tested, testNext, testNow = (Point)i$.next(), safest, step++))) {
            }
        }
        System.out.println(safest);
        return (Dir)((Object)moveDir.get(safest));
    }

    private static boolean viableSpot(int[][] targetMap, Integer[][] safeMap, Point spot) {
        Integer[][] newSafeMap = new Integer[safeMap.length][];
        for (int i = 0; i < safeMap.length; ++i) {
            newSafeMap[i] = new Integer[safeMap[0].length];
            for (int j = 0; j < safeMap[0].length; ++j) {
                if (safeMap[i][j] == null) continue;
                newSafeMap[i][j] = new Integer(safeMap[i][j]);
            }
        }
        safeMap = newSafeMap;
        boolean targetInRange = false;
        for (int i = -2; i <= 2; ++i) {
            if (spot.y + i >= 0 && spot.y + i < targetMap.length && targetMap[spot.y + i][spot.x] > 0) {
                targetInRange = true;
            }
            if (spot.x + i >= 0 && spot.x + i < targetMap[0].length && targetMap[spot.y][spot.x + i] > 0) {
                targetInRange = true;
            }
            Kai.setSafeMap(safeMap, spot.x + i, spot.y, 5);
            Kai.setSafeMap(safeMap, spot.x, spot.y + i, 5);
        }
        if (!targetInRange) {
            return false;
        }
        Dir move = Kai.moveDirToSafety(safeMap, spot);
        return move != Dir.IDLE;
    }

    private static boolean viableConnected(int[][] targetMap, Integer[][] safeMap, HashMap<Point, Dir> moveDir, ArrayList<Point> tested, ArrayList<Point> testNext, Point testNow, Point viable) {
        Point[] surrounding;
        if (Kai.viableSpot(targetMap, safeMap, testNow)) {
            viable.setLocation(testNow);
            return false;
        }
        tested.add(testNow);
        if (targetMap[testNow.y][testNow.x] != 0) {
            return true;
        }
        for (Point point : surrounding = new Point[]{new Point(testNow.x - 1, testNow.y), new Point(testNow.x + 1, testNow.y), new Point(testNow.x, testNow.y - 1), new Point(testNow.x, testNow.y + 1)}) {
            if (point.x < 0 || point.x >= safeMap[0].length || point.y < 0 || point.y >= safeMap.length || tested.contains(point)) continue;
            if (!testNext.contains(point)) {
                testNext.add(point);
            }
            if (moveDir.containsKey(point)) continue;
            moveDir.put(point, moveDir.get(testNow));
        }
        return true;
    }

    private static Dir moveDirToViableSpot(int[][] targetMap, Integer[][] safeMap, Point pos) {
        boolean cont;
        int x = pos.x;
        int y = pos.y;
        Point viable = new Point(pos);
        HashMap<Point, Dir> moveDir = new HashMap<Point, Dir>();
        moveDir.put(viable, Dir.IDLE);
        moveDir.put(new Point(x, y - 1), Dir.UP);
        moveDir.put(new Point(x + 1, y), Dir.RIGHT);
        moveDir.put(new Point(x, y + 1), Dir.DOWN);
        moveDir.put(new Point(x - 1, y), Dir.LEFT);
        ArrayList<Point> tested = new ArrayList<Point>();
        ArrayList<Point> testNext = new ArrayList<Point>();
        testNext.add(viable);
        boolean bl = cont = !Kai.viableSpot(targetMap, safeMap, viable);
        while (cont && !testNext.isEmpty()) {
            Point testNow;
            ArrayList<Point> testNowAll = testNext;
            testNext = new ArrayList();
            Iterator i$ = testNowAll.iterator();
            while (i$.hasNext() && (cont = Kai.viableConnected(targetMap, safeMap, moveDir, tested, testNext, testNow = (Point)i$.next(), viable))) {
            }
        }
        return (Dir)((Object)moveDir.get(viable));
    }

    private static void moveToConnected(Integer[][] safeMap, HashMap<Point, Dir> moveDir, ArrayList<Point> tested, ArrayList<Point> testNext, Point testNow, int step) {
        Point[] surrounding;
        Integer safetyHere;
        tested.add(testNow);
        if (safeMap[testNow.y][testNow.x] != null && (safetyHere = Integer.valueOf(safeMap[testNow.y][testNow.x] - step)) < 2 && step >= 0) {
            return;
        }
        for (Point point : surrounding = new Point[]{new Point(testNow.x - 1, testNow.y), new Point(testNow.x + 1, testNow.y), new Point(testNow.x, testNow.y - 1), new Point(testNow.x, testNow.y + 1)}) {
            if (point.x < 0 || point.x >= safeMap[0].length || point.y < 0 || point.y >= safeMap.length || tested.contains(point)) continue;
            if (!testNext.contains(point)) {
                testNext.add(point);
            }
            if (moveDir.containsKey(point)) continue;
            moveDir.put(point, moveDir.get(testNow));
        }
    }

    private static Dir canMoveToSafely(Integer[][] safeMap, Point from, Point to) {
        if (from.equals(to)) {
            return Dir.IDLE;
        }
        int x = from.x;
        int y = from.y;
        int step = -1;
        HashMap<Point, Dir> moveDir = new HashMap<Point, Dir>();
        moveDir.put(from, Dir.IDLE);
        moveDir.put(new Point(x, y - 1), Dir.UP);
        moveDir.put(new Point(x + 1, y), Dir.RIGHT);
        moveDir.put(new Point(x, y + 1), Dir.DOWN);
        moveDir.put(new Point(x - 1, y), Dir.LEFT);
        ArrayList<Point> tested = new ArrayList<Point>();
        ArrayList<Point> testNext = new ArrayList<Point>();
        testNext.add(from);
        Dir move = Dir.IDLE;
        block0: while (!testNext.isEmpty()) {
            ArrayList<Point> testNowAll = testNext;
            testNext = new ArrayList();
            for (Point testNow : testNowAll) {
                Kai.moveToConnected(safeMap, moveDir, tested, testNext, testNow, step++);
                if (!testNext.contains(to)) continue;
                move = moveDir.get(testNow);
                testNext = new ArrayList();
                continue block0;
            }
        }
        return move;
    }

    private static enum Dir {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        IDLE;

    }

    private static enum Tile {
        HARD,
        NONE,
        SOFT;

    }
}

