#include "ThinkGoal.h"
#include "Player.h"
#include "MoveToGoal.h"
#include "ExploreGoal.h"
#include "Evaluators.h"
#include "GameManager.h"
#include "AttackGoal.h"
#include "FleeToSafePos.h"
#include <vector>
#include <algorithm>
#include <map>

const double kBombRiskEvalWeight = 1.0;

void ThinkGoal::Activate()
{
    m_isFleeing = false;
    m_status = OdinAI::GOAL_ACTIVE;
    Clear();

    const PlayerManager& playerManager = gGameMgr.GetPlayerMgr();
    auto& playerMap = playerManager.GetPlayers();
    
    bool areOnAttack = false;
    if(!gGameMgr.IsSuddenDeath())
    {
        for(auto iter = playerMap.begin();
            iter != playerMap.end();++iter)
        {
            const Player *pPlayer = &iter->second;
            if (!pPlayer->IsDead() && std::abs(m_pOwner->GetPosition().x - pPlayer->GetPosition().x) <= 10 &&
                std::abs(m_pOwner->GetPosition().y - pPlayer->GetPosition().y) <= 10)
            {
                AddGoal(new AttackGoal(m_pOwner, iter->first));
                areOnAttack = true;
            }
        }
    }

    if(!areOnAttack)
    {
        if(gGameMgr.IsSuddenDeath())
        {
            AddGoal(new FleeToSafePos(m_pOwner, gGameMgr.GetMap().GetMap()));
        }
        else
        {
            AddGoal(new ExploreGoal(m_pOwner));
        }
    }
}

int ThinkGoal::Process()
{
    ActivateIfInactive();

    std::vector< std::vector<char> > bombMap = gGameMgr.GetMap().GetMap();
    //gGameMgr.GetBombMgr().FillMap(&bombMap);
    BombRiskEval bombRiskEval(m_pOwner, bombMap);
    double result = bombRiskEval.Desireability();

    if(!m_isFleeing && result > 0.0)
    {
        Clear();
        m_isFleeing = true;
        AddGoal(new FleeGoal(m_pOwner, bombMap));
    }

    m_status = ProcessSubgoals();

    return m_status;
}

void ThinkGoal::End()
{
}