#include "PlayerManager.h"
#include <iostream>
#include <string>
#include <sstream>

void PlayerManager::UpdatePlayer(int id, const iVec2& pos)
{
	m_players[id].SetPosition(pos);
    m_players[id].Revive();
	m_numPlayers = m_players.size();
}

void PlayerManager::KillAllPlayers()
{
    for(auto iter = m_players.begin();
        iter != m_players.end();++iter)
    {
        iter->second.Kill();
    }
}

const Player *PlayerManager::GetPlayer(int id) const
{
    return &m_players.at(id);
}

void PlayerManager::UpdateOurPlayer(const iVec2 &pos)
{
    m_ourPlayer.SetPosition(pos);
}

const Player *PlayerManager::GetOurPlayer() const
{
    return &m_ourPlayer;
}

Player *PlayerManager::GetOurPlayer()
{
    return &m_ourPlayer;
}