#include <string>
#include <sstream>
#include <iostream>
#include <functional>
#include "Map.h"
#include "GameManager.h"

bool GameManager::OnInit(int argc, char** argv)
{
	srand(static_cast<OdinAI::uint>(time(0)));
	std::cout << "Drops and bass is loading some crazy rythms." << std::endl;
	std::cout << "Prepare your dance moves!" << std::endl;

    if(!NewRound())
        return false;

    char *url = "127.0.0.1";
    if(argc > 1)
    {
        url = argv[1];
    }
	if (!m_networkManager.Connect(url, "54321", std::bind(&GameManager::AsyncRecv, this, std::placeholders::_1, std::placeholders::_2)))
		return false;

    m_networkManager.Send("NAME D'N'B\n", strlen("NAME D'N'B\n"));

	return true;
}

bool GameManager::NewRound()
{
    if (!m_playerManager.Init())
		return false;

    m_brain.Init(m_playerManager.GetOurPlayer());

    m_hasInitMap = false;
    m_mapOffset = 0;
    m_bombsOffset = 0;

    return true;
}

bool GameManager::OnLoop()
{
    return true;
}

bool GameManager::IsSuddenDeath() const
{
    return m_map.GetNumStones() <= 0;
}

void GameManager::AsyncRecv(char *data, int size)
{
    //std::cout.write(data, size);
    data[size] = '\0';

    std::istringstream stream(data);
    std::string cmdLine; 
    int width, height;
    int x, y;
    while(getline(stream, cmdLine).good())
    {
        if(cmdLine.find("HEIGHT") != std::string::npos)
        {
            height = atoi(cmdLine.substr(strlen("HEIGHT ")).c_str());
        }
        else if(cmdLine.find("WIDTH") != std::string::npos)
        {
            width = atoi(cmdLine.substr(strlen("WIDTH ")).c_str());
        }
        else if(cmdLine[0] == 'X')
        {
            x = atoi(cmdLine.substr(strlen("X ")).c_str());
        }
        else if(cmdLine[0] == 'Y')
        {
            y = atoi(cmdLine.substr(strlen("Y ")).c_str());
            m_playerManager.UpdateOurPlayer(iVec2(x, y));
        }
        else if(cmdLine == "ENDOFROUND")
        {
            NewRound();
        }
        else if(cmdLine.find("BOMBS") != std::string::npos || m_bombsOffset > 0)
        {
            if(cmdLine.find("BOMBS") != std::string::npos)
            {
                m_bombManager.Clear();
            }

            if(m_bombsOffset > 0)
            {
                memcpy(&buffer[m_bombsOffset], cmdLine.c_str(), 3 * sizeof(int) + 2);

                m_bombsOffset += 3 * sizeof(int) + 2;
            }

            while(getline(stream, cmdLine).good() && cmdLine.find("ENDBOMBS") == std::string::npos)
            {
                memcpy(&buffer[m_bombsOffset], cmdLine.c_str(), 3 * sizeof(int) + 2);

                m_bombsOffset += 3 * sizeof(int) + 2;
            }

            if(cmdLine.find("ENDBOMBS") != std::string::npos)
            {
                std::string str(buffer);
                for(int i = 0;i < m_bombsOffset;i += 3 * sizeof(int) + 2)
                {
                    std::string bombStr = str.substr(i, 3 * sizeof(int) + 2);
                    bombStr[bombStr.length()] = '\n';
                    Bomb bomb;

                    size_t posSplit = bombStr.find(',');
                    size_t tickSplit = bombStr.find(' ');
                    bomb.position.x = atoi(bombStr.substr(0, posSplit).c_str());
                    bomb.position.y = atoi(bombStr.substr(posSplit + 1, tickSplit).c_str());
                    bomb.gameTicks =  atoi(bombStr.substr(tickSplit + 1).c_str());
                    m_bombManager.m_bombs.push_back(bomb);
                }

                m_bombsOffset = 0;
            }
        }
        else if(cmdLine.find("PLAYERS") != std::string::npos)
        {
            m_playerManager.KillAllPlayers();
            while(getline(stream, cmdLine).good() && cmdLine.find("ENDPLAYERS") == std::string::npos)
            { 
				iVec2 pos;
				int id;
				size_t idSplit;
				size_t posSplit;
				
				idSplit = cmdLine.find(' ');
				id = atoi(cmdLine.substr(0, idSplit).c_str());
				
				posSplit = cmdLine.find(',');
				
				pos.x = atoi(cmdLine.substr(idSplit, posSplit).c_str());
				pos.y = atoi(cmdLine.substr(posSplit + 1, std::string::npos).c_str());
				
				m_playerManager.UpdatePlayer(id, pos);
			}
        }
        else if(cmdLine == "MAP" || m_mapOffset > 0)
        {
            if(m_mapOffset > 0)
            {
                memcpy(&buffer[m_mapOffset], cmdLine.c_str(), cmdLine.length());
                m_mapOffset += cmdLine.size();
            }

            while(getline(stream, cmdLine) && cmdLine.find("ENDMAP") == std::string::npos)
            {
                memcpy(&buffer[m_mapOffset], cmdLine.c_str(), cmdLine.length());
                m_mapOffset += cmdLine.size();
            }

            if(!m_hasInitMap)
            {
                m_map.Init(width, height, buffer);
                m_hasInitMap = true;
            }

            if(cmdLine.find("ENDMAP") != std::string::npos)
            {
                m_mapOffset = 0;
                m_map.Update(buffer);
                m_brain.Update();
            }
        }
    }
}