#include "BombManager.h"
#include "GameManager.h"

const std::vector<Bomb> &BombManager::GetBombs() const
{
    return m_bombs;
}

void BombManager::FillMap(std::vector< std::vector<char> > *map) const
{
    std::vector< std::vector<char> > &refMap = *map;
    for(auto iter = m_bombs.begin();
        iter != m_bombs.end();++iter)
    {
        const iVec2 &bombPos = iter->position;
        if(iter->gameTicks < 32)
        {
            refMap[bombPos.x][bombPos.y] = iter->gameTicks;
        }
    }

    for(auto iter = m_bombs.begin();
        iter != m_bombs.end();++iter)
    {
        FillArea(map, iter->position, iter->gameTicks);
    }

    for(auto iter = m_bombs.begin();
        iter != m_bombs.end();++iter)
    {
        const iVec2 &bombPos = iter->position;
        int ticks = refMap[bombPos.x][bombPos.y];

        for(int x = -2;x <= 2;++x)
        {
            int newX = bombPos.x + x;
            if(newX >= 0 && newX < gGameMgr.GetMap().GetSizeX())
            {
                if(gGameMgr.GetMap().IsTileStandAble(refMap[newX][bombPos.y]) || refMap[newX][bombPos.y] < 32)
                {
                    refMap[newX][bombPos.y] = ticks < refMap[newX][bombPos.y] ? ticks : refMap[newX][bombPos.y];
                }
            }
        }
    
        for(int y = -2;y <= 2;++y)
        {
            int newY = bombPos.y + y;
            if(newY >= 0 && newY < gGameMgr.GetMap().GetSizeY())
            {
                if(gGameMgr.GetMap().IsTileStandAble(refMap[bombPos.x][newY]) || refMap[bombPos.y][newY] < 32)
                {
                    refMap[bombPos.x][newY] = ticks < refMap[bombPos.x][newY] ? ticks : refMap[bombPos.x][newY];
                }
            }
        }
    }
}

void BombManager::Clear()
{
    /*std::vector<Bomb> tmp;
    for(auto iter = m_bombs.begin();iter != m_bombs.end();++iter)
    {
        if(iter->gameTicks == 1)
        {
            iter->gameTicks = 0;
            tmp.push_back(*iter);
        }
    }*/
    m_bombs.clear();
    //m_bombs = tmp;
}

void BombManager::FillArea(std::vector< std::vector<char> > *map, const iVec2 &pos, int tick) const
{
    std::vector< std::vector<char> > &refMap = *map;
    for(auto iter = m_bombs.begin();
        iter != m_bombs.end();++iter)
    {
        for(int x = -2;x <= 2;++x)
        {
            int newX = pos.x + x;
            if(newX >= 0 && newX < gGameMgr.GetMap().GetSizeX())
            {
                if(x != 0)
                {
                    if(iVec2(newX, pos.y) == iter->position)
                    {
                        if(tick < refMap[newX][pos.y])
                        {
                            refMap[newX][pos.y] = tick;
                            FillArea(map, iVec2(newX, pos.x), tick);
                        }
                    }
                }
            }
        }
    
        for(int y = -2;y <= 2;++y)
        {
            int newY = pos.y + y;
            if(newY >= 0 && newY < gGameMgr.GetMap().GetSizeY())
            {
                if(y != 0)
                {
                    if(iVec2(pos.x, newY) == iter->position)
                    {
                        if(tick < refMap[pos.x][newY])
                        {
                            refMap[pos.x][newY] = tick;
                            FillArea(map, iVec2(pos.x, newY), tick);
                        }
                    }
                }
            }
        }
    }
}