#include "BombGoal.h"
#include "Player.h"
#include "GameManager.h"
#include "FleeGoal.h"
#include <vector>
#include <queue>

void BombGoal::Activate()
{
    std::vector< std::vector<char> > bombMap = gGameMgr.GetMap().GetMap();
    iVec2 bombPos = m_pPlayer->GetPosition();
    
    for (int i = bombPos.x - 2; i <= (bombPos.x + 2); i++)
    {
        if (i >= 0 && i < gGameMgr.GetMap().GetSizeX())
        {
            if (gGameMgr.GetMap().IsTileStandAble(bombMap[i][bombPos.y]) && bombMap[i][bombPos.y] > 5)
                bombMap[i][bombPos.y] = 5;
        }
    }
    for (int i = bombPos.y - 2; i <= (bombPos.y + 2); i++)
    {
        if (i >= 0 && i < gGameMgr.GetMap().GetSizeY()) 
        {
            if (gGameMgr.GetMap().IsTileStandAble(bombMap[bombPos.x][i]) && bombMap[bombPos.x][i] > 5)
                bombMap[bombPos.x][i] = 5;
        }
    }

    gGameMgr.GetBombMgr().FillMap(&bombMap);

    if (FleeGoal::CreateEscapePlan(m_pPlayer, bombMap).size() < 5)
    {
        gGameMgr.GetNetworkMgr().Send("BOMB\n", strlen("BOMB\n"));
        m_status = OdinAI::GOAL_COMPLETE;
    }
    else
    {
        m_status = OdinAI::GOAL_FAILED;
    }
}

int BombGoal::Process()
{
    ActivateIfInactive();

    return m_status;
}

void BombGoal::End()
{
}
